from fileinput import filename
import os
import bpy
from shutil import copyfile,rmtree
from bpy import context
from bpy.types import Operator
from bpy_extras import view3d_utils
import json
from bpy_extras.io_utils import ImportHelper,ExportHelper
from bpy.props import StringProperty


# ### teste para achar atributos
# link do site: https://blender.stackexchange.com/questions/6544/how-to-check-if-an-object-has-a-custom-property-with-python
# ob = bpy.context.active_object
# hasattr(ob, "char")

# To test for bpy.props properties / attributes:

# hasattr(ob, "char")
# Or get the attribute:

# # note: throws AttributeError if not existing
# getattr(ob, "char") 

# # don't throw exception but return default (None) value if not existing
# getattr(ob, "char", None)
# To test for a certain ID property, use:

# bpy.data.objects['Object'].get('char') is not None

##############################################################

class BlockHandler:
    def __init__(self, value):
         self.value = value

    @property
    def value(self):
         # Este código é executado quando alguém for
         # ler o valor de self.nome
         return self._value

    @value.setter
    def value(self, val):
         # este código é executado sempre que alguém fizer 
         # self.nome = value
         self._value = val


from contextlib import contextmanager
global UPDT_FUNC

@contextmanager
def contextoveride(area_type: str):
    area = bpy.context.area
    former_area_type = area.type
    area.type = area_type
    area.region[0] = 'WINDOW'
    try:
        yield area
        
    finally:
        area.type = former_area_type

def uniquify(path):
    filename, extension = os.path.splitext(path)
    counter = 1

    while os.path.exists(path):
        # path = filename + " (" + str(counter) + ")" + extension
        path = filename + '_{0:03d}'.format(counter) + extension
        counter += 1

    return path


def fix_selected_particle(context):
    dyna_groom = context.scene.dyna_groom_prop
    id_to_update_name = dyna_groom.enum_hair_curr_section
    if id_to_update_name == '':
        id_to_update_name = 1 
    if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
        bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1


def update_hair_values_on_panel(context,panel = 1):#a opcao panel, e quando eutiver rodando por algum painel de selecao, assim elee nao entra em loop e crasha
                                                #0 = nao atualizar painel de opçõos
                                                #1 = atualizar painel
    dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    # if id_to_update_name == '':
    #     id_to_update_name = 1
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id


    dyna_groom.int_hair_number = bpy.context.object.particle_systems[idx_particle].settings.count
    dyna_groom.int_hair_size = bpy.context.object.particle_systems[idx_particle].settings.hair_length
    dyna_groom.int_hair_step = bpy.context.object.particle_systems[idx_particle].settings.hair_step
    dyna_groom.int_hair_display_step = bpy.context.object.particle_systems[idx_particle].settings.display_step
    dyna_groom.bool_hair_render_bspline = bpy.context.object.particle_systems[idx_particle].settings.use_hair_bspline 
    if bpy.context.scene.render.hair_type == 'STRAND':
         dyna_groom.bool_hair_render_strand = True
    if bpy.context.scene.render.hair_type == 'STRIP':
         dyna_groom.bool_hair_render_strip = True
    dyna_groom.bool_hair_show_emitter_viewport = bpy.context.object.show_instancer_for_viewport
    dyna_groom.bool_hair_show_emitter_render = bpy.context.object.show_instancer_for_render
    dyna_groom.int_hair_render_step = bpy.context.object.particle_systems[idx_particle].settings.render_step 
    dyna_groom.enum_hair_material = bpy.context.object.particle_systems[idx_particle].settings.material_slot

    #tool option
    dyna_groom.int_particle_edit_display_step = bpy.context.scene.tool_settings.particle_edit.display_step
    dyna_groom.bool_particle_edit_show_children = bpy.context.scene.tool_settings.particle_edit.show_particles
    
    if panel == 1:
        if bpy.context.object.particle_systems[idx_particle].settings.child_type == 'NONE':
            dyna_groom.bool_children_none = True
            dyna_groom.bool_children_simple = False
            dyna_groom.bool_children_interpolated = False
        elif bpy.context.object.particle_systems[idx_particle].settings.child_type == 'SIMPLE':
            dyna_groom.bool_children_none = False
            dyna_groom.bool_children_simple = True
            dyna_groom.bool_children_interpolated = False
        elif bpy.context.object.particle_systems[idx_particle].settings.child_type == 'INTERPOLATED':
            dyna_groom.bool_children_none = False
            dyna_groom.bool_children_simple = False
            dyna_groom.bool_children_interpolated = True
    
    ### config de children
    dyna_groom.enum_children = bpy.context.object.particle_systems[idx_particle].settings.child_type
    dyna_groom.int_children_display_amount =bpy.context.object.particle_systems[idx_particle].settings.child_nbr
    dyna_groom.int_children_render_amount =bpy.context.object.particle_systems[idx_particle].settings.rendered_child_count
    dyna_groom.float_children_length = bpy.context.object.particle_systems[idx_particle].settings.child_length
    dyna_groom.float_children_threshold = bpy.context.object.particle_systems[idx_particle].settings.child_length_threshold
    dyna_groom.int_children_seed = bpy.context.object.particle_systems[idx_particle].child_seed
    
    dyna_groom.float_children_virtual_parents = bpy.context.object.particle_systems[idx_particle].settings.virtual_parents
    dyna_groom.bool_children_long_hair = bpy.context.object.particle_systems[idx_particle].settings.create_long_hair_children
    
    dyna_groom.float_children_size = bpy.context.object.particle_systems[idx_particle].settings.child_size
    dyna_groom.float_children_random_size = bpy.context.object.particle_systems[idx_particle].settings.child_size_random
    dyna_groom.float_children_radius = bpy.context.object.particle_systems[idx_particle].settings.child_radius
    dyna_groom.float_children_roundness =  bpy.context.object.particle_systems[idx_particle].settings.child_roundness


    # ### Children Parting
    dyna_groom.float_children_parting_parting =bpy.context.object.particle_systems[idx_particle].settings.child_parting_factor
    dyna_groom.float_children_parting_min = bpy.context.object.particle_systems[idx_particle].settings.child_parting_min
    dyna_groom.float_children_parting_max = bpy.context.object.particle_systems[idx_particle].settings.child_parting_max

    # ### Clumping
    dyna_groom.float_children_clump_clump = bpy.context.object.particle_systems[idx_particle].settings.clump_factor
    dyna_groom.float_children_clump_shape = bpy.context.object.particle_systems[idx_particle].settings.clump_shape
    dyna_groom.bool_children_clump_noise = bpy.context.object.particle_systems[idx_particle].settings.use_clump_noise
    dyna_groom.float_children_clump_noise_size = bpy.context.object.particle_systems[idx_particle].settings.clump_noise_size
    dyna_groom.float_children_clump_twist = bpy.context.object.particle_systems[idx_particle].settings.twist

    # ### Roughness
    dyna_groom.float_children_roughness_uniform = bpy.context.object.particle_systems[idx_particle].settings.roughness_1
    dyna_groom.float_children_roughness_size  = bpy.context.object.particle_systems[idx_particle].settings.roughness_1_size
    dyna_groom.float_children_roughness_endpoint = bpy.context.object.particle_systems[idx_particle].settings.roughness_endpoint
    dyna_groom.float_children_roughness_shape = bpy.context.object.particle_systems[idx_particle].settings.roughness_end_shape
    dyna_groom.float_children_roughness_random = bpy.context.object.particle_systems[idx_particle].settings.roughness_2
    dyna_groom.float_children_roughness_size2 = bpy.context.object.particle_systems[idx_particle].settings.roughness_2_size
    dyna_groom.float_children_roughness_threshold = bpy.context.object.particle_systems[idx_particle].settings.roughness_2_threshold

    ### Kink
    if panel == 1:
        dyna_groom.bool_children_kink_nothing = True if bpy.context.object.particle_systems[idx_particle].settings.kink == 'NO' else False
        dyna_groom.bool_children_kink_curl = True if bpy.context.object.particle_systems[idx_particle].settings.kink == 'CURL' else False
        dyna_groom.bool_children_kink_radial = True if bpy.context.object.particle_systems[idx_particle].settings.kink == 'RADIAL' else False
        dyna_groom.bool_children_kink_wave = True if bpy.context.object.particle_systems[idx_particle].settings.kink == 'WAVE' else False
        dyna_groom.bool_children_kink_braid = True if bpy.context.object.particle_systems[idx_particle].settings.kink == 'BRAID' else False
        dyna_groom.bool_children_kink_spiral = True if bpy.context.object.particle_systems[idx_particle].settings.kink == 'SPIRAL' else False

    


    # ### Kink
    dyna_groom.float_children_kink_amplitude = bpy.context.object.particle_systems[idx_particle].settings.kink_amplitude
    dyna_groom.float_children_kink_clump = bpy.context.object.particle_systems[idx_particle].settings.kink_amplitude_clump
    dyna_groom.float_children_kink_flatness = bpy.context.object.particle_systems[idx_particle].settings.kink_flat
    dyna_groom.float_children_kink_frequency = bpy.context.object.particle_systems[idx_particle].settings.kink_frequency
    dyna_groom.float_children_kink_shape = bpy.context.object.particle_systems[idx_particle].settings.kink_shape
    dyna_groom.float_children_kink_amplitude_random = bpy.context.object.particle_systems[idx_particle].settings.kink_amplitude_random
    dyna_groom.enum_children_kink_axis = bpy.context.object.particle_systems[idx_particle].settings.kink_axis
    dyna_groom.float_children_kink_axis_random = bpy.context.object.particle_systems[idx_particle].settings.kink_axis_random
    dyna_groom.int_children_kink_axis_steps = bpy.context.object.particle_systems[idx_particle].settings.kink_extra_steps

    # # ###### Hair Shape
    dyna_groom.float_hair_strand_shape = bpy.context.object.particle_systems[idx_particle].settings.shape
    dyna_groom.float_hair_strand_diameter_root = bpy.context.object.particle_systems[idx_particle].settings.root_radius
    dyna_groom.float_hair_strand_diameter_tip = bpy.context.object.particle_systems[idx_particle].settings.tip_radius
    dyna_groom.float_hair_strand_diameter_scale = bpy.context.object.particle_systems[idx_particle].settings.radius_scale
    dyna_groom.bool_hair_strand_close_tip = bpy.context.object.particle_systems[idx_particle].settings.use_close_tip

     
    ## atualizar os vertex groups
    vg_density = bpy.context.object.particle_systems[idx_particle].vertex_group_density
    vg_length = bpy.context.object.particle_systems[idx_particle].vertex_group_length
    vg_clump = bpy.context.object.particle_systems[idx_particle].vertex_group_clump
    vg_kink = bpy.context.object.particle_systems[idx_particle].vertex_group_kink
    vg_roughness1 = bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_1
    vg_roughness2 = bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_2
    vg_roughnessend = bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_end
    vg_twist = bpy.context.object.particle_systems[idx_particle].vertex_group_twist

    dyna_groom.enum_hair_vert_group_density = '-' if vg_density == '' else vg_density
    dyna_groom.enum_hair_vert_group_length = '-' if vg_length == '' else vg_length
    dyna_groom.enum_hair_vert_group_clump = '-' if vg_clump == '' else vg_clump
    dyna_groom.enum_hair_vert_group_kink = '-' if vg_kink == '' else vg_kink
    dyna_groom.enum_hair_vert_group_rough1 = '-' if vg_roughness1 == '' else vg_roughness1
    dyna_groom.enum_hair_vert_group_rough2 = '-' if vg_roughness2 == '' else vg_roughness2
    dyna_groom.enum_hair_vert_group_roughend = '-' if vg_roughnessend == '' else vg_roughnessend
    dyna_groom.enum_hair_vert_group_twist = '-' if vg_twist == '' else vg_twist
    


class ApplyHair(Operator):
    bl_idname = "hair.apply_dynamics"
    bl_label = "Apply Dynamic"
    bl_description = "Apply Dynamics to Hair Particles"

    def execute(self,context):

        if context.mode != 'PARTICLE':
            orig_context = context.mode
        
            bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        # dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        # if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
        #     bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1
       
        # How to use:
        # 1. edit hair system (important, move at least one hair, at least a bit to initiate hair editing)
        # 2. run hair dynamics
        # 3. move to frame where dynamics should be applied
        # 4. run script
        # 5. if happy, delete cache
        # 6. keep editing hair

        # get the depsgraph and the evaluated object   
        deps_graph = bpy.context.evaluated_depsgraph_get()
        evaluated_object = bpy.context.object.evaluated_get(deps_graph)
        # assume context object has a particle system (warning, no check), use active
        particle_system = evaluated_object.particle_systems.active

        # Variable to hold hair-verticies-coordinats
        hairs = []

        # At current frame
        # For each particle (hair)
        #   For each vertex
        #     Store XYZ coordinates
        for p in particle_system.particles:
            hair = []
            for v in p.hair_keys:
                hair.append([v.co[0], v.co[1], v.co[2]])
            hairs.append(hair)

        # Deactivate hair dynamics 
        particle_system.use_hair_dynamics = False
        # bpy.context.object.particle_systems[int(id_to_update_name)-1].use_hair_dynamics = 0

        # On static hair system
        # For each particle (hair)
        #   For each vertex
        #     Overwrite XYZ coordinates
        for p,hair in zip(particle_system.particles,hairs):
            for v,h in zip(p.hair_keys,hair):
                #print(v.co, h)
                v.co[0] = h[0]
                v.co[1] = h[1]
                v.co[2] = h[2]
                #print(v.co, h)

        bpy.ops.particle.brush_edit(stroke=[{"name":"", "location":(0, 0, 0), "mouse":(126, 160), "mouse_event":(0, 0), "pressure":0, "size":0, "pen_flip":False, "x_tilt":0, "y_tilt":0, "time":0, "is_start":False}])
        # print('context area type: ',bpy.context.area.type)


        # Update view and UI
        # bpy.context.scene.frame_set(bpy.context.scene.frame_current)
        bpy.context.scene.frame_set(bpy.context.scene.frame_start)

        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id

        #update dependency grapah again necessery to make it properly work
        deps_graph = bpy.context.evaluated_depsgraph_get()
        evaluated_object = bpy.context.object.evaluated_get(deps_graph)
        particle_system = evaluated_object.particle_systems.active
        particle_system.use_hair_dynamics = False
        bpy.context.object.particle_systems[idx_particle].use_hair_dynamics = 0

        bpy.ops.particle.brush_edit(stroke=[{"name":"", "location":(0, 0, 0), "mouse":(0, 0), "mouse_event":(0, 0), "pressure":0, "size":0, "pen_flip":False, "x_tilt":0, "y_tilt":0, "time":0, "is_start":False}, {"name":"", "location":(0, 0, 0), "mouse":(0, 0), "mouse_event":(0, 0), "pressure":0, "size":0, "pen_flip":False, "x_tilt":0, "y_tilt":0, "time":0, "is_start":False}, {"name":"", "location":(0, 0, 0), "mouse":(0, 0), "mouse_event":(0, 0), "pressure":0, "size":0, "pen_flip":False, "x_tilt":0, "y_tilt":0, "time":0, "is_start":False}])

        
        # bpy.ops.object.mode_set(mode=orig_context)

        return{'FINISHED'}


class ModePath(Operator):
    bl_idname = "hair.mode_path"
    bl_label = "Mode = Path"
    bl_description = "Change to Mode Path"

    def execute(self,context):

        dyna_groom = context.scene.dyna_groom_prop
        id_to_update_name = dyna_groom.enum_hair_curr_section
        if id_to_update_name == '':
            id_to_update_name = 1 
        if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
            bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1

        if context.mode != 'PARTICLE':
        
            bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        bpy.context.scene.tool_settings.particle_edit.select_mode = 'PATH'

        return{'FINISHED'}


class ModePoint(Operator):
    bl_idname = "hair.mode_point"
    bl_label = "Mode =  Point"
    bl_description = "Mode Point"

    def execute(self,context):

        dyna_groom = context.scene.dyna_groom_prop
        id_to_update_name = dyna_groom.enum_hair_curr_section
        if id_to_update_name == '':
            id_to_update_name = 1 
        if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
            bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1

        if context.mode != 'PARTICLE':
        
            bpy.ops.object.mode_set(mode='PARTICLE_EDIT')
       
        bpy.context.scene.tool_settings.particle_edit.select_mode = 'POINT'

        return{'FINISHED'}


class ModeTip(Operator):
    bl_idname = "hair.mode_tip"
    bl_label = "Mode =  Tip"
    bl_description = "Mode Tip"

    def execute(self,context):

        dyna_groom = context.scene.dyna_groom_prop
        id_to_update_name = dyna_groom.enum_hair_curr_section
        if id_to_update_name == '':
            id_to_update_name = 1 
        if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
            bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1

        if context.mode != 'PARTICLE':
        
            bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        
        bpy.context.scene.tool_settings.particle_edit.select_mode = 'TIP'

        return{'FINISHED'}





class SelectRoot(Operator):
    bl_idname = "hair.select_root"
    bl_label = "Root"
    bl_description = "Select root of Hair"

    def execute(self,context):
        # dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        # if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
        #     bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1

        # if context.mode != 'PARTICLE':
        
        #     bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        # bpy.context.scene.tool_settings.particle_edit.select_mode = 'POINT'
        # bpy.ops.particle.select_all(action='DESELECT')
        bpy.ops.particle.select_roots()
        # bpy.ops.particle.select_more()

        return{'FINISHED'}

class SelectRootAndNext(Operator):
    bl_idname = "hair.select_root_and_next"
    bl_label = "Root and Next"
    bl_description = "Select root of Hair and the next key"

    def execute(self,context):
        # dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        # if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
        #     bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1

        # idx = context.active_object.hair_list_index
        # idx_particle = context.active_object.hair_list[idx].particle_system_id
        # hair_settings = context.active_object.particle_systems[idx_particle].settings
        # hair_list_shapekey = hair_settings.particle_shape
        # hair_list_shapekey_index = hair_settings.particle_shape_index

        if context.mode != 'PARTICLE':
        
            bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        bpy.context.scene.tool_settings.particle_edit.select_mode = 'POINT'
        bpy.ops.particle.select_all(action='DESELECT')
        bpy.ops.particle.select_roots()
        bpy.ops.particle.select_more()

        return{'FINISHED'}


class SelectTip(Operator):
    bl_idname = "hair.select_tip"
    bl_label = "Tip"
    bl_description = "Select Tip of Hair"

    def execute(self,context):
        # dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        # if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
        #     bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1

        # if context.mode != 'PARTICLE':
        
        #     bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        # bpy.context.scene.tool_settings.particle_edit.select_mode = 'POINT'
        # bpy.ops.particle.select_all(action='DESELECT')
        bpy.ops.particle.select_tips()
        # bpy.ops.particle.select_more()
        return{'FINISHED'}




class SelectPointMore(Operator):
    bl_idname = "hair.select_point_more"
    bl_label = "(+)"
    bl_description = "Select More Points"

    def execute(self,context):
        # dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        # if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
        #     bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1

        # if context.mode != 'PARTICLE':
        
        #     bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        # bpy.context.scene.tool_settings.particle_edit.select_mode = 'POINT'
        bpy.ops.particle.select_more()

        return{'FINISHED'}

class SelectPointLess(Operator):
    bl_idname = "hair.select_point_less"
    bl_label = "(-)"
    bl_description = "Select Less Points"

    def execute(self,context):
        # dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        # if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
        #     bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1

        # if context.mode != 'PARTICLE':
        
        #     bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        # bpy.context.scene.tool_settings.particle_edit.select_mode = 'POINT'
        bpy.ops.particle.select_less()

        return{'FINISHED'}

class InvertSelection(Operator):
    bl_idname = "hair.invert_selection"
    bl_label = "Invert"
    bl_description = "Invert Selection"

    def execute(self,context):
        # dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section

        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        # if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
        #     bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1

        # if context.mode != 'PARTICLE':
        
        #     bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        # bpy.context.scene.tool_settings.particle_edit.select_mode = 'POINT'
        
        bpy.ops.particle.select_all(action='INVERT')


        return{'FINISHED'}




class ToggleParticleContext(Operator):
    bl_idname = "hair.toggle_particle_context"
    bl_label = "Toggle Context"
    bl_description = "Toggle Particle Context"

    def execute(self,context):

        bpy.ops.particle.particle_edit_toggle()

        return{'FINISHED'}


class AddDynamics(Operator):
    bl_idname = "hair.add_dynamics"
    bl_label = "Add Dynamics"
    bl_description = "Add Dynamics"

    def execute(self,context):

        dyna_groom = context.scene.dyna_groom_prop

        # # get the depsgraph and the evaluated object   
        # deps_graph = bpy.context.evaluated_depsgraph_get()
        # evaluated_object = bpy.context.object.evaluated_get(deps_graph)
        # # assume context object has a particle system (warning, no check), use active
        # particle_system = evaluated_object.particle_systems.active

        # particle_system.use_hair_dynamics = True
        # bpy.context.object.particle_systems["ParticleSystem"].use_hair_dynamics = True


        # dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        # if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
        #     bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1

        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id


        if context.mode == 'PARTICLE':
        
            bpy.ops.object.mode_set(mode='OBJECT')

        bpy.context.scene.frame_set(bpy.context.scene.frame_start)

        
        bpy.context.object.particle_systems[idx_particle].use_hair_dynamics = True


        return{'FINISHED'}


class AddHairParticles(Operator):
    bl_idname = "hair.add_hair"
    bl_label = "Add Hair"
    bl_description = "Add Hair"

    def execute(self,context):

        dyna_groom = context.scene.dyna_groom_prop
        id_to_update_name = dyna_groom.enum_hair_curr_section
        if id_to_update_name == '':
            id_to_update_name = 1 
        
        
        if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
            bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1
        

        # if context.mode != 'PARTICLE':
        #     bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        bpy.ops.object.particle_system_add()
        last_particle = len(bpy.data.particles)
        bpy.data.particles[last_particle-1].type = 'HAIR'

        return{'FINISHED'}

class CreateHairSections(Operator):
    bl_idname = "hair.create_hair_sections"
    bl_label = "Create Hair sections"
    bl_description = "Create Hair Sections"

    def execute(self,context):

        dyna_groom = context.scene.dyna_groom_prop
        qtd_particles = dyna_groom.int_hair_sections

        for p in range(qtd_particles):
            bpy.ops.object.particle_system_add()

            bpy.context.object.particle_systems[p].name = str(p+1)
            bpy.context.object.particle_systems[p].settings.name = str(p+1)+'-'
            bpy.context.object.particle_systems[p].settings.type = 'HAIR'


        # dyna_groom.bool_edit_hair_sections = False

        hair_sections = []
        for c in range(qtd_particles):
                hair_sections.append([c+1,'',''])
        dyna_groom.str_json_sections = json.dumps(hair_sections)

        # Apos criar as particulas, deixa a primeira como ativa, para ficar sincronizado com a enumproperty
        bpy.context.active_object.particle_systems.active_index = 0

        #set tha panel to the value on the particles panel
        
        # dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1

        # dyna_groom.int_hair_number = bpy.context.object.particle_systems[int(id_to_update_name)-1].settings.count
        # dyna_groom.int_hair_size = bpy.context.object.particle_systems[int(id_to_update_name)-1].settings.hair_length
        
        # dyna_groom.enum_children = bpy.context.object.particle_systems[int(id_to_update_name)-1].settings.child_type
        # dyna_groom.int_children_display_amount =bpy.context.object.particle_systems[int(id_to_update_name)-1].settings.child_nbr
        # dyna_groom.int_children_render_amount =bpy.context.object.particle_systems[int(id_to_update_name)-1].settings.rendered_child_count

        update_hair_values_on_panel(context)

        return{'FINISHED'}



class AddHairSections(Operator):
    bl_idname = "hair.add_hair_sections"
    bl_label = "Add Hair sections"
    bl_description = "Add Hair Sections"

    def execute(self,context):

        dyna_groom = context.scene.dyna_groom_prop
        # qtd_particles = dyna_groom.int_hair_sections
        hair_sections = json.loads(dyna_groom.str_json_sections)

        p = len(hair_sections)

        
        bpy.ops.object.particle_system_add()

        bpy.context.object.particle_systems[p].name = str(p+1)
        bpy.context.object.particle_systems[p].settings.name = str(p+1)+'-'
        bpy.context.object.particle_systems[p].settings.type = 'HAIR'


        # dyna_groom.bool_edit_hair_sections = False

        hair_sections = []
        for c in range(p+1):
                hair_sections.append([c+1,'',''])
        dyna_groom.str_json_sections = json.dumps(hair_sections)

        # Apos criar as particulas, deixa a primeira como ativa, para ficar sincronizado com a enumproperty
        bpy.context.active_object.particle_systems.active_index = 0

        update_hair_values_on_panel(context)

        return{'FINISHED'}



class EditHairSections(Operator):
    bl_idname = "hair.edit_hair_sections"
    bl_label = "Edit Hair sections"
    bl_description = "Edit Hair Sections"

    def execute(self,context):

        dyna_groom = context.scene.dyna_groom_prop

        # bpy.ops.object.particle_system_add()
        # last_particle = len(bpy.data.particles)
        # bpy.data.particles[last_particle-1].type = 'HAIR'

        qtd_particles = dyna_groom.int_hair_sections
        for p in range(qtd_particles):
            bpy.ops.object.particle_system_remove()

        dyna_groom.bool_edit_hair_sections = True

        return{'FINISHED'}


class ClearVgDensitySelection(Operator):
    bl_idname = "hair.clear_vg_density_selection"
    bl_label = "Clear VG Density Selection"
    bl_description = "Clear VG Density Selection"

    def execute(self,context):

        dyna_groom = context.scene.dyna_groom_prop
        id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        # if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
        #     bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1

        # fix_selected_particle(context)

        bpy.context.object.particle_systems[int(id_to_update_name)-1].vertex_group_density = ''


        return{'FINISHED'}
    
class ParticleEditClear(Operator):
    bl_idname = "hair.particle_edit_clear"
    bl_label = "Clear Particle Edit"
    bl_description = "Clear Particle Edit"

    def invoke(self, context, event):
        return context.window_manager.invoke_confirm(self, event)

    def execute(self,context):

        orig_context = context.mode
        if context.mode != 'PARTICLE':
            bpy.ops.object.mode_set(mode='PARTICLE_EDIT')
        else:
            orig_context = 'PARTICLE_EDIT'

        bpy.ops.particle.edited_clear()

        bpy.ops.object.mode_set(mode=orig_context)


        return{'FINISHED'}


#Select the layer on the list
class SelectHairLayer(Operator):
    bl_idname = "hair.select_hair_layer"
    bl_label = "Select Hair Layer"
    bl_description = "Select Hair Layer"

    hair_id: bpy.props.IntProperty(name="Id of Hair")

    def execute(self,context):

       
        context.active_object.hair_list_index = self.hair_id
        

        return{'FINISHED'}


### show hide viwport

class HideViewportHair(Operator):
    bl_idname = "hair.hide_viewport_hair"
    bl_label = "Hide Viewport Hair"
    bl_description = "Hide Viewport Hair"

    hair_id: bpy.props.IntProperty(name="Id of Hair")
    # hair_name: bpy.props.StringProperty(name="Name of Hair")

    def execute(self,context):

        i = 0
        hair_name=''
        for mod in bpy.context.object.modifiers:
            if mod.type == 'PARTICLE_SYSTEM':
                if i == self.hair_id:
                    # print(i)
                    hair_name = mod.name
                    # print(hair_name)
                i = i+1
        bpy.context.object.modifiers[hair_name].show_viewport = False
        # bpy.context.object.modifiers[self.hair_name].show_viewport = False
        

        return{'FINISHED'}

class ShowViewportHair(Operator):
    bl_idname = "hair.show_viewport_hair"
    bl_label = "Show Viewport Hair"
    bl_description = "Show Viewport Hair"

    hair_id: bpy.props.IntProperty(name="Id of Hair")
    # hair_name: bpy.props.StringProperty(name="Name of Hair")

    def execute(self,context):

        i = 0
        hair_name=''
        for mod in bpy.context.object.modifiers:
            if mod.type == 'PARTICLE_SYSTEM':
                if i == self.hair_id:
                    # print(i)
                    hair_name = mod.name
                    # print(hair_name)
                i = i+1
        bpy.context.object.modifiers[hair_name].show_viewport = True
        # bpy.context.object.modifiers[self.hair_name].show_viewport = True

        return{'FINISHED'}


#### show hide render hair

class HideRenderHair(Operator):
    bl_idname = "hair.hide_render_hair"
    bl_label = "Hide Render Hair"
    bl_description = "Hide Render Hair"

    hair_id: bpy.props.IntProperty(name="Id of Hair")

    def execute(self,context):

       
        i = 0
        hair_name=''
        for mod in bpy.context.object.modifiers:
            if mod.type == 'PARTICLE_SYSTEM':
                if i == self.hair_id:
                    # print(i)
                    hair_name = mod.name
                    # print(hair_name)
                i = i+1
        bpy.context.object.modifiers[hair_name].show_render = False

        return{'FINISHED'}

class ShowRenderHair(Operator):
    bl_idname = "hair.show_render_hair"
    bl_label = "Show Render Hair"
    bl_description = "Show Render Hair"

    hair_id: bpy.props.IntProperty(name="Id of Hair")

    def execute(self,context):

       
        i = 0
        hair_name=''
        for mod in bpy.context.object.modifiers:
            if mod.type == 'PARTICLE_SYSTEM':
                if i == self.hair_id:
                    # print(i)
                    hair_name = mod.name
                    # print(hair_name)
                i = i+1
        bpy.context.object.modifiers[hair_name].show_render = True

        return{'FINISHED'}


### gravity enable/disable

class HairDynamicsOn(Operator):
    bl_idname = "hair.hair_dynamics_on"
    bl_label = "Enable Hair Dynamics"
    bl_description = "Enable Hair Dynamics"

    hair_id: bpy.props.IntProperty(name="Id of Hair")

    def execute(self,context):

        
       
        # bpy.context.object.particle_systems[self.hair_id-1].use_hair_dynamics = True
        bpy.context.object.particle_systems[self.hair_id].use_hair_dynamics = True

        return{'FINISHED'}

class HairDynamicsOff(Operator):
    bl_idname = "hair.hair_dynamics_off"
    bl_label = "Disable Hair Dynamics"
    bl_description = "Disable Hair Dynamics"

    hair_id: bpy.props.IntProperty(name="Id of Hair")

    def execute(self,context):

        
       
        # bpy.context.object.particle_systems[self.hair_id-1].use_hair_dynamics = False
        bpy.context.object.particle_systems[self.hair_id].use_hair_dynamics = False

        return{'FINISHED'}


#Lock unlock hair layer
class LockHairLayer(Operator):
    bl_idname = "hair.lock_hair_layer"
    bl_label = "Lock Hair Layer"
    bl_description = "Lock Hair Layer"

    hair_id: bpy.props.IntProperty(name="Id of Hair")

    def execute(self,context):

        context.active_object.hair_list[self.hair_id].bool_lock_hair_layer = True
        update_hair_values_on_panel(context)

        return{'FINISHED'}
class UnlockHairLayer(Operator):
    bl_idname = "hair.unlock_hair_layer"
    bl_label = "Unlock Hair Layer"
    bl_description = "Unlock Hair Layer"

    hair_id: bpy.props.IntProperty(name="Id of Hair")

    def execute(self,context):

        context.active_object.hair_list[self.hair_id].bool_lock_hair_layer = False
        update_hair_values_on_panel(context)

        return{'FINISHED'}

####################################################################
#################
#################  Quality of Hair
class HqHair(Operator):
    bl_idname = "hair.hq_hair"
    bl_label = "High quality"
    bl_description = "High quality Hair"

    def execute(self,context):

        # dyna_groom = context.scene.dyna_groom_prop

        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        # hair_sections = json.loads(dyna_groom.str_json_sections)
        # for h in hair_sections:
        #     if h[0] ==int(id_to_update_name):
        #         particle = str(h[0])+'-'+h[1]

        # bpy.data.particles[particle].hair_step = 10
        # bpy.data.particles[particle].render_step = 10
        # bpy.data.particles[particle].display_step = 10

        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id

        context.active_object.particle_systems[idx].settings.hair_step = 10
        context.active_object.particle_systems[idx].settings.render_step = 10
        context.active_object.particle_systems[idx].settings.display_step = 10

        update_hair_values_on_panel(context)
        
        return{'FINISHED'}

class MqHair(Operator):
    bl_idname = "hair.mq_hair"
    bl_label = "Medium quality"
    bl_description = "Medium quality Hair"

    def execute(self,context):
        # dyna_groom = context.scene.dyna_groom_prop

        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        # hair_sections = json.loads(dyna_groom.str_json_sections)
        # for h in hair_sections:
        #     if h[0] ==int(id_to_update_name):
        #         particle = str(h[0])+'-'+h[1]

        # bpy.data.particles[particle].hair_step = 6
        # bpy.data.particles[particle].render_step = 6
        # bpy.data.particles[particle].display_step = 6

        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id

        context.active_object.particle_systems[idx].settings.hair_step = 6
        context.active_object.particle_systems[idx].settings.render_step = 6
        context.active_object.particle_systems[idx].settings.display_step = 6

        update_hair_values_on_panel(context)
        
        return{'FINISHED'}

class LqHair(Operator):
    bl_idname = "hair.lq_hair"
    bl_label = "Low quality"
    bl_description = "Low quality Hair"

    def execute(self,context):

        # dyna_groom = context.scene.dyna_groom_prop

        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        # hair_sections = json.loads(dyna_groom.str_json_sections)
        # for h in hair_sections:
        #     if h[0] ==int(id_to_update_name):
        #         particle = str(h[0])+'-'+h[1]

        # bpy.data.particles[particle].hair_step = 2
        # bpy.data.particles[particle].render_step = 2
        # bpy.data.particles[particle].display_step = 2

        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id

        context.active_object.particle_systems[idx].settings.hair_step = 2
        context.active_object.particle_systems[idx].settings.render_step = 2
        context.active_object.particle_systems[idx].settings.display_step = 2

        update_hair_values_on_panel(context)
        

        return{'FINISHED'}


#################
#################  Quality of Hair
####################################################################





####################################################################
#################
#################  Profiles
class Hair1(Operator):
    bl_idname = "hair.hair1"
    bl_label = "hair1"
    bl_description = "hair1"

    def execute(self,context):

        dyna_groom = context.scene.dyna_groom_prop


        id_to_update_name = dyna_groom.enum_hair_curr_section
        if id_to_update_name == '':
            id_to_update_name = 1 
        hair_sections = json.loads(dyna_groom.str_json_sections)
        for h in hair_sections:
            if h[0] ==int(id_to_update_name):
                particle = str(h[0])+'-'+h[1]
        
        bpy.data.particles[particle].count = 100
        bpy.data.particles[particle].hair_length = 1
        bpy.data.particles[particle].hair_step = 6
        bpy.data.particles[particle].render_step = 6
        bpy.data.particles[particle].display_step = 6
        bpy.data.particles[particle].child_nbr = 10
        bpy.data.particles[particle].child_type = 'INTERPOLATED'

        return{'FINISHED'}


class Hair2(Operator):
    bl_idname = "hair.hair2"
    bl_label = "hair2"
    bl_description = "hair2"

    def execute(self,context):

        dyna_groom = context.scene.dyna_groom_prop

        id_to_update_name = dyna_groom.enum_hair_curr_section
        if id_to_update_name == '':
            id_to_update_name = 1 
        hair_sections = json.loads(dyna_groom.str_json_sections)
        for h in hair_sections:
            if h[0] ==int(id_to_update_name):
                particle = str(h[0])+'-'+h[1]
        
        bpy.data.particles[particle].count = 100
        bpy.data.particles[particle].hair_length = 4
        bpy.data.particles[particle].hair_step = 6
        bpy.data.particles[particle].render_step = 6
        bpy.data.particles[particle].display_step = 6
        bpy.data.particles[particle].child_nbr = 10
        bpy.data.particles[particle].kink = 'BRAID'
        bpy.data.particles[particle].count = 1
        bpy.data.particles[particle].child_type = 'SIMPLE'
        bpy.data.particles[particle].kink_amplitude = 0.15
        bpy.data.particles[particle].kink_frequency = 3.431
        bpy.data.particles[particle].kink_shape = -0.0271837
        bpy.data.particles[particle].kink_amplitude = 0.12
        bpy.data.particles[particle].roughness_2 = 0
        bpy.data.particles[particle].roughness_1 = 0
        bpy.data.particles[particle].clump_factor = 0.829932
        bpy.data.particles[particle].clump_shape = 0.530082
        bpy.data.particles[particle].clump_shape = 0.0427645
        bpy.data.particles[particle].clump_factor = 0.829932
        bpy.data.particles[particle].child_nbr = 60


        return{'FINISHED'}

class SavePreset(Operator):
    bl_idname = "hair.save_preset"
    bl_label = "Save Preset"
    bl_description = "Save Preset"

    def execute(self,context):
        # from .variables import Variables
        dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.active_object.particle_systems[idx_particle].settings
        hair_list_shapekey = hair_settings.particle_shape
        hair_list_shapekey_index = hair_settings.particle_shape_index

        o_ps = 'bpy.context.object.particle_systems[idx_particle].'
        ao_ps_s = 'bpy.context.active_object.particle_systems[idx_particle].settings.'
        ao_ps_c = 'bpy.context.active_object.particle_systems[idx_particle].cloth.'

        hair_preset =[  ['d',ao_ps_s+'count' , eval(ao_ps_s+'count')],
                        #bpy.context.object.particle_systems["2"].seed' , eval(
                        ['d',o_ps+'seed' , eval(o_ps+'seed')],
                        ['f',ao_ps_s+'hair_length' , eval(ao_ps_s+'hair_length')],
                        ['f',ao_ps_s+'hair_step' , eval(ao_ps_s+'hair_step')-1],
                        ['s',ao_ps_s+'emit_from' , eval(ao_ps_s+'emit_from')],
                        ['d',ao_ps_s+'use_modifier_stack' , eval(ao_ps_s+'use_modifier_stack')],
                        ['s',ao_ps_s+'distribution' , eval(ao_ps_s+'distribution')],
                        ['d',ao_ps_s+'use_emit_random' , eval(ao_ps_s+'use_emit_random')],
                        ['d',ao_ps_s+'use_even_distribution' , eval(ao_ps_s+'use_even_distribution')],
                        ['d',ao_ps_s+'userjit' , eval(ao_ps_s+'userjit')],
                        ['f',ao_ps_s+'jitter_factor' , eval(ao_ps_s+'jitter_factor')],

                        ##################################################################

                        ### hair dynmics #cacaor osparametros aqui dentro
                        ['d',o_ps+'use_hair_dynamics' , eval(o_ps+'use_hair_dynamics')],

                        ##########################################
                        #Render
                        ['s',ao_ps_s+'render_type' , eval(ao_ps_s+'render_type')],
                        ['s',ao_ps_s+'material_slot' , eval(ao_ps_s+'material_slot')],
                        #bpy.context.object.particle_systems["2"].parent' , eval(
                        ['s',o_ps+'parent' , eval(o_ps+'parent')],
                        ['d','bpy.context.object.show_instancer_for_render' , eval('bpy.context.object.show_instancer_for_render')],

                            ##path
                            ['d',ao_ps_s+'use_hair_bspline' , eval(ao_ps_s+'use_hair_bspline')],
                            ['d',ao_ps_s+'render_step' , eval(ao_ps_s+'render_step')],


                            #timing
                            ['d',ao_ps_s+'use_absolute_path_time' , eval(ao_ps_s+'use_absolute_path_time')],
                            ['d',ao_ps_s+'path_start' , eval(ao_ps_s+'path_start')],
                            ['d',ao_ps_s+'path_end' , eval(ao_ps_s+'path_end')],
                            ['d',ao_ps_s+'length_random' , eval(ao_ps_s+'length_random')],


                            #extra
                            ['d',ao_ps_s+'use_parent_particles' , eval(ao_ps_s+'use_parent_particles')],
                            ['d',ao_ps_s+'show_unborn' , eval(ao_ps_s+'show_unborn')],
                            ['d',ao_ps_s+'use_dead' , eval(ao_ps_s+'use_dead')],


                        #Viewport Display
                        ['s',ao_ps_s+'display_method' , eval(ao_ps_s+'display_method')],
                        ['s',ao_ps_s+'display_color' , eval(ao_ps_s+'display_color')],
                        ['d',ao_ps_s+'display_step' , eval(ao_ps_s+'display_step')],
                        ['d',ao_ps_s+'display_percentage' , eval(ao_ps_s+'display_percentage')],
                        ['d','bpy.context.object.show_instancer_for_viewport' , eval('bpy.context.object.show_instancer_for_viewport')],

                        #Children
                            #OPT1
                            ['s',ao_ps_s+'child_type' , eval(ao_ps_s+'child_type' )],

                            #OPT2
                            #----------
                            # ['s',ao_ps_s+'child_type' , eval(ao_ps_s+'child_type')],
                            #----------
                                ['d',ao_ps_s+'child_nbr' , eval(ao_ps_s+'child_nbr')],
                                ['d',ao_ps_s+'rendered_child_count' , eval(ao_ps_s+'rendered_child_count')],
                                ['d',ao_ps_s+'child_length' , eval(ao_ps_s+'child_length')],
                                ['d',ao_ps_s+'child_length_threshold' , eval(ao_ps_s+'child_length_threshold')],

                                ['d',o_ps+'child_seed' , eval(o_ps+'child_seed')],
                                ['d',ao_ps_s+'child_size' , eval(ao_ps_s+'child_size')],
                                ['d',ao_ps_s+'child_size_random' , eval(ao_ps_s+'child_size_random')],
                                ['f',ao_ps_s+'child_radius' , eval(ao_ps_s+'child_radius')],
                                ['d',ao_ps_s+'child_roundness' , eval(ao_ps_s+'child_roundness')],
                                
                                ##Clumping
                                ['d',ao_ps_s+'use_clump_curve' , eval(ao_ps_s+'use_clump_curve')],
                                ['d',ao_ps_s+'clump_factor' , eval(ao_ps_s+'clump_factor')],
                                ['d',ao_ps_s+'clump_shape' , eval(ao_ps_s+'clump_shape')],
                                ['d',ao_ps_s+'twist' , eval(ao_ps_s+'twist')],
                                ['d',ao_ps_s+'use_twist_curve' , eval(ao_ps_s+'use_twist_curve')],
                                ['d',ao_ps_s+'use_clump_noise' , eval(ao_ps_s+'use_clump_noise')],
                                ['d',ao_ps_s+'clump_noise_size' , eval(ao_ps_s+'clump_noise_size')],
                                    
                                #Roughness
                                ['d',ao_ps_s+'use_roughness_curve' , eval(ao_ps_s+'use_roughness_curve')],
                                ['d',ao_ps_s+'roughness_1' , eval(ao_ps_s+'roughness_1')],
                                ['d',ao_ps_s+'roughness_1_size' , eval(ao_ps_s+'roughness_1_size')],
                                ['d',ao_ps_s+'roughness_endpoint' , eval(ao_ps_s+'roughness_endpoint')],
                                ['d',ao_ps_s+'roughness_end_shape' , eval(ao_ps_s+'roughness_end_shape')],
                                ['d',ao_ps_s+'roughness_2' , eval(ao_ps_s+'roughness_2')],
                                ['d',ao_ps_s+'roughness_2_size' , eval(ao_ps_s+'roughness_2_size')],
                                ['d',ao_ps_s+'roughness_2_threshold' , eval(ao_ps_s+'roughness_2_threshold')],
                                
                                #kink
                                    #Opt1
                                    ['s',ao_ps_s+'kink' , eval(ao_ps_s+'kink')],


                                    #opt coes com variaveis iguas
                                    # ['s',ao_ps_s+'kink = 'CURL
                                    # ['s',ao_ps_s+'kink = 'RADIAL'
                                    # ['s',ao_ps_s+'kink = 'WAVE'
                                    # ['s',ao_ps_s+'kink = 'BRAID'
                                    
                                    #------
                                    ['f',ao_ps_s+'kink_amplitude' , eval(ao_ps_s+'kink_amplitude')],
                                    ['d',ao_ps_s+'kink_amplitude_clump' , eval(ao_ps_s+'kink_amplitude_clump')],
                                    ['d',ao_ps_s+'kink_flat' , eval(ao_ps_s+'kink_flat')],
                                    ['d',ao_ps_s+'kink_frequency' , eval(ao_ps_s+'kink_frequency')],
                                    ['d',ao_ps_s+'kink_shape' , eval(ao_ps_s+'kink_shape')],

                                    #opt com variaveis diferentes
                                    #------
                                    ['f',ao_ps_s+'kink_amplitude' , eval(ao_ps_s+'kink_amplitude')],
                                    ['d',ao_ps_s+'kink_amplitude_random' , eval(ao_ps_s+'kink_amplitude_random')],
                                    ['s',ao_ps_s+'kink_axis' , eval(ao_ps_s+'kink_axis')],
                                    ['d',ao_ps_s+'kink_axis_random' , eval(ao_ps_s+'kink_axis_random')],
                                    ['f',ao_ps_s+'kink_frequency' , eval(ao_ps_s+'kink_frequency')],
                                    ['d',ao_ps_s+'kink_extra_steps' , eval(ao_ps_s+'kink_extra_steps')],


                        #hair Shape
                        ['d',ao_ps_s+'shape' , eval(ao_ps_s+'shape')],
                        ['d',ao_ps_s+'root_radius' , eval(ao_ps_s+'root_radius')],
                        ['d',ao_ps_s+'tip_radius' , eval(ao_ps_s+'tip_radius')],
                        ['f',ao_ps_s+'radius_scale' , eval(ao_ps_s+'radius_scale')],
                        ['d',ao_ps_s+'use_close_tip' , eval(ao_ps_s+'use_close_tip')],

                        #Field Weights
                        ['s',ao_ps_s+'effector_weights.collection' , eval(ao_ps_s+'effector_weights.collection')],
                        ['d',ao_ps_s+'effector_weights.all' , eval(ao_ps_s+'effector_weights.all')],
                        ['d',ao_ps_s+'effector_weights.force' , eval(ao_ps_s+'effector_weights.force')],
                        ['d',ao_ps_s+'effector_weights.vortex' , eval(ao_ps_s+'effector_weights.vortex')],
                        ['d',ao_ps_s+'effector_weights.magnetic' , eval(ao_ps_s+'effector_weights.magnetic')],
                        ['d',ao_ps_s+'effector_weights.harmonic' , eval(ao_ps_s+'effector_weights.harmonic')],
                        ['d',ao_ps_s+'effector_weights.charge' , eval(ao_ps_s+'effector_weights.charge')],
                        ['d',ao_ps_s+'effector_weights.lennardjones' , eval(ao_ps_s+'effector_weights.lennardjones')],
                        ['d',ao_ps_s+'effector_weights.wind' , eval(ao_ps_s+'effector_weights.wind')],
                        ['d',ao_ps_s+'effector_weights.curve_guide' , eval(ao_ps_s+'effector_weights.curve_guide')],
                        ['d',ao_ps_s+'effector_weights.texture' , eval(ao_ps_s+'effector_weights.texture')],
                        ['d',ao_ps_s+'effector_weights.smokeflow' , eval(ao_ps_s+'effector_weights.smokeflow')],
                        ['d',ao_ps_s+'effector_weights.turbulence' , eval(ao_ps_s+'effector_weights.turbulence')],
                        ['d',ao_ps_s+'effector_weights.drag' , eval(ao_ps_s+'effector_weights.drag')],
                        ['d',ao_ps_s+'effector_weights.boid' , eval(ao_ps_s+'effector_weights.boid')],

                        ['d',ao_ps_s+'effector_weights.apply_to_hair_growing' , eval(ao_ps_s+'effector_weights.apply_to_hair_growing')],
                        ['d',ao_ps_s+'apply_effector_to_children' , eval(ao_ps_s+'apply_effector_to_children')],

                        ['d',ao_ps_s+'effect_hair' , eval(ao_ps_s+'effect_hair')]
                    ]
        



        hair_preset_final = []
        if eval(o_ps+'use_hair_dynamics') == True:

            hair_preset_dynamics =[ ['d',ao_ps_c+'settings.quality' , eval(ao_ps_c+'settings.quality')],
                            ['d',ao_ps_c+'settings.pin_stiffness' , eval(ao_ps_c+'settings.pin_stiffness')],
                            #collisions
                            ['d',ao_ps_c+'collision_settings.collision_quality' , eval(ao_ps_c+'collision_settings.collision_quality')],
                            ['f',ao_ps_c+'collision_settings.distance_min' , eval(ao_ps_c+'collision_settings.distance_min')],
                            ['f',ao_ps_c+'collision_settings.impulse_clamp' , eval(ao_ps_c+'collision_settings.impulse_clamp')],
                            #collision collection
                            ['s',ao_ps_c+'collision_settings.collection' , eval(ao_ps_c+'collision_settings.collection')],

                            #structure
                            ['f',ao_ps_c+'settings.mass' , eval(ao_ps_c+'settings.mass')],
                            ['f',ao_ps_c+'settings.bending_stiffness' , eval(ao_ps_c+'settings.bending_stiffness')],
                            ['f',ao_ps_s+'bending_random' , eval(ao_ps_s+'bending_random')],
                            ['f',ao_ps_c+'settings.bending_damping' , eval(ao_ps_c+'settings.bending_damping')],

                            #volume
                            ['d',ao_ps_c+'settings.air_damping' , eval(ao_ps_c+'settings.air_damping')],
                            ['d',ao_ps_c+'settings.internal_friction' , eval(ao_ps_c+'settings.internal_friction')],
                            ['f',ao_ps_c+'settings.voxel_cell_size' , eval(ao_ps_c+'settings.voxel_cell_size')],
                            ['d',ao_ps_c+'settings.density_target' , eval(ao_ps_c+'settings.density_target')],
                            ['d',ao_ps_c+'settings.density_strength' , eval(ao_ps_c+'settings.density_strength')]
            ]

            hair_preset_final.append(hair_preset_dynamics)
        else:
            hair_preset_final = hair_preset



        dyna_groom = context.scene.dyna_groom_prop

        folder_path = os.path.dirname(os.path.realpath(__file__))
        name_preset = dyna_groom.str_save_preset_name
            
        preset_file = os.path.join(folder_path, 'presets', 'PRESET_'+name_preset+'.json')
        preset_file = uniquify(preset_file)

        #save!!!
        import json
        with open(preset_file, 'w') as f:
            json.dump(hair_preset_final, f)

        return{'FINISHED'}

class LoadPreset(Operator):
    bl_idname = "hair.load_preset"
    bl_label = "Load Preset"
    bl_description = "Load Preset"

    def execute(self,context):
        # from .variables import Variables
        dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.active_object.particle_systems[idx_particle].settings
        hair_list_shapekey = hair_settings.particle_shape
        hair_list_shapekey_index = hair_settings.particle_shape_index

        # o_ps = 'bpy.context.object.particle_systems[int(id_to_update_name)-1].'
        # ao_ps_s = 'bpy.context.active_object.particle_systems[int(id_to_update_name)-1].settings.'
        # ao_ps_c = 'bpy.context.active_object.particle_systems[int(id_to_update_name)-1].cloth.'

        # if context.mode != 'PARTICLE':
        #     bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        # orig_context = context.mode
        if context.mode != 'PARTICLE':
        
            bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        bpy.ops.particle.edited_clear()
                            


        folder_path = os.path.dirname(os.path.realpath(__file__))
        name_preset_load = dyna_groom.enum_load_preset.replace('.json','')
            
        preset_file = os.path.join(folder_path, 'presets', name_preset_load+'.json')

        import json
        with open(preset_file) as json_file:
            data = json.load(json_file)
            # print(data)
            

        for d in data:

            #temporariamente fazer bypass quando salvar preset com cores
            if d[1] !=  'bpy.context.active_object.particle_systems[idx_particle].settings.material_slot':

                # print(d)
                # if d[0] == 'd':
                #     exec('%s = %d' %(d[1], d[2]))
                if d[0] == 'f' or d[0] == 'd':
                    exec('%s = %f' %(d[1], d[2]))
                if d[0] == 's':
                    exec('%s = %a' %(d[1], d[2]))

        bpy.ops.object.mode_set(mode='OBJECT')    
        # bpy.ops.object.mode_set(mode=orig_context)


        update_hair_values_on_panel(context)

        return{'FINISHED'}


class SaveStyle(Operator):
    bl_idname = "hair.save_style"
    bl_label = "Save Style"
    bl_description = "Save Style"

    def execute(self,context):
        # from .variables import Variables
        dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 

        # idx = context.active_object.hair_list_index
        # idx_particle = context.active_object.hair_list[idx].particle_system_id
        # hair_settings = context.active_object.particle_systems[idx_particle].settings
        # hair_list_shapekey = hair_settings.particle_shape
        # hair_list_shapekey_index = hair_settings.particle_shape_index



        folder_path = os.path.dirname(os.path.realpath(__file__))
        name_preset = dyna_groom.str_save_preset_name
            
        preset_file = os.path.join(folder_path, 'presets', 'STYLE_'+name_preset+'.json')
        preset_file = uniquify(preset_file)

        deps_graph = bpy.context.evaluated_depsgraph_get()
        evaluated_object = bpy.context.object.evaluated_get(deps_graph)
        # assume context object has a particle system (warning, no check), use active
        particle_system = evaluated_object.particle_systems.active

        # Variable to hold hair-verticies-coordinats
        hairs = []

        # At current frame
        # For each particle (hair)
        #   For each vertex
        #     Store XYZ coordinates
        for p in particle_system.particles:
            hair = []
            for v in p.hair_keys:
                hair.append([v.co[0], v.co[1], v.co[2]])
            hairs.append(hair)


        #save!!!
        import json
        with open(preset_file, 'w') as f:
            json.dump(hairs, f)


        update_hair_values_on_panel(context)


        return{'FINISHED'}



class LoadStyle(Operator):
    bl_idname = "hair.load_style"
    bl_label = "Load Style"
    bl_description = "Load Style"

    def execute(self,context):
        # from .variables import Variables
        dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.active_object.particle_systems[idx_particle].settings
        hair_list_shapekey = hair_settings.particle_shape
        hair_list_shapekey_index = hair_settings.particle_shape_index


        folder_path = os.path.dirname(os.path.realpath(__file__))
        name_preset_load = dyna_groom.enum_load_preset_style.replace('.json','')
            
        preset_file = os.path.join(folder_path, 'presets', name_preset_load+'.json')
        

        import json
        with open(preset_file) as json_file:
            data = json.load(json_file)
            # print(data)

        if context.mode != 'PARTICLE':
        
            bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        # bpy.ops.particle.edited_clear() #nao ativar senao gera erro

        bool_pre_apply = bpy.context.object.particle_systems[idx_particle].use_hair_dynamics
            

        deps_graph = bpy.context.evaluated_depsgraph_get()
        evaluated_object = bpy.context.object.evaluated_get(deps_graph)
        # assume context object has a particle system (warning, no check), use active
        particle_system = evaluated_object.particle_systems.active

        # Variable to hold hair-verticies-coordinats
        hairs = data

        # # At current frame
        # # For each particle (hair)
        # #   For each vertex
        # #     Store XYZ coordinates
        # for p in particle_system.particles:
        #     hair = []
        #     for v in p.hair_keys:
        #         hair.append([v.co[0], v.co[1], v.co[2]])
        #     hairs.append(hair)

        # Deactivate hair dynamics
        particle_system.use_hair_dynamics = False
        # bpy.context.object.particle_systems[int(id_to_update_name)-1].use_hair_dynamics = 0

        # On static hair system
        # For each particle (hair)
        #   For each vertex
        #     Overwrite XYZ coordinates
        for p,hair in zip(particle_system.particles,hairs):
            for v,h in zip(p.hair_keys,hair):
                #print(v.co, h)
                v.co[0] = h[0]
                v.co[1] = h[1]
                v.co[2] = h[2]
                #print(v.co, h)

        
        
        # bpy.ops.particle.brush_edit(stroke=[{"name":"", "location":(0, 0, 0), "mouse":(126, 160), "mouse_event":(0, 0), "pressure":0, "size":0, "pen_flip":False, "x_tilt":0, "y_tilt":0, "time":0, "is_start":False}])
        
        # bpy.ops.object.mode_set(mode='OBJECT')


        bpy.context.object.particle_systems[idx_particle].use_hair_dynamics = bool_pre_apply
        
        return{'FINISHED'}

class FindContext(Operator):
    bl_idname = "hair.find_context"
    bl_label = "Find Context"
    bl_description = "Find Context"

    def execute(self,context):
        print('context: ', bpy.context.area.type)

        return{'FINISHED'}

class ImportPresetOrStyle(Operator,ImportHelper):
    bl_idname = "hair.import_preset_or_style"
    bl_label = "Import File"
    bl_description = "Import Preset or Style File"

    filename_ext = ".json"
    filter_glob: StringProperty(
        default="*.json",
        options={'HIDDEN'},
        maxlen=255,  # Max internal buffer length, longer would be clamped.
    )
    def execute(self,context):

        
        path_addon = os.path.dirname(os.path.abspath(__file__))
        path_preset_style = os.path.join(path_addon,'presets')
        if not os.path.exists(path_preset_style):
            os.makedirs(path_preset_style)

        src = self.filepath
        dst_name = os.path.basename(src)
        dst_full = os.path.join(path_preset_style,dst_name)
        dst = uniquify(dst_full)
        

        copyfile(src, dst)
        return{'FINISHED'}

class ExportPresetOrStyle(Operator,ExportHelper):
    bl_idname = "hair.export_preset_or_style"
    bl_label = "Export File"
    bl_description = "Export Preset or Style File"


    filename_ext = ".json"
    filter_glob: StringProperty(
        default="*.json",
        options={'HIDDEN'},
        maxlen=255,  # Max internal buffer length, longer would be clamped.
    )

    #esse invoke passar por cima do padrao do exporthelper, que e, colocar o nome untitled
    def invoke(self, context, event):
        dyna_groom = context.scene.dyna_groom_prop
        file_to_export = dyna_groom.enum_preset_or_style_to_export
        self.filepath = file_to_export
        context.window_manager.fileselect_add(self)
        return {'RUNNING_MODAL'}
    def execute(self,context):

        dyna_groom = context.scene.dyna_groom_prop
        path_addon = os.path.dirname(os.path.abspath(__file__))
        path_preset_style = os.path.join(path_addon,'presets')
        
        file_to_export = dyna_groom.enum_preset_or_style_to_export
        src = os.path.join(path_preset_style,file_to_export)
        # dst = os.path.join(os.path.dirname(self.filepath),file_to_export)
        self.blend_filepath  = file_to_export
        dst = self.filepath
        
        
        copyfile(src, dst)
        return{'FINISHED'}


class PlayPause(Operator):
    bl_idname = "hair.play_pause"
    bl_label = "Play/Pause"
    bl_description = "Play/Pause"

    def execute(self,context):
        # if context.mode == 'PARTICLE':
        #     bpy.ops.object.mode_set(mode='OBJECT')
        bpy.ops.screen.animation_play()
        return{'FINISHED'}

class Rewind(Operator):
    bl_idname = "hair.rewind"
    bl_label = "Rewind"
    bl_description = "Rewind"

    def execute(self,context):
        bpy.ops.screen.frame_jump(end=False)
        return{'FINISHED'}

class UpdtPanelFromParticles(Operator):
    bl_idname = "hair.updt_panel_from_particles"
    bl_label = "Update Panel from Particles"
    bl_description = "Update Panel from Particles"

    def execute(self,context):
        update_hair_values_on_panel(context)
        return{'FINISHED'}

class UpdtParticlesDisplay(Operator):
    bl_idname = "hair.updt_particle_display"
    bl_label = "Update Particles Display"
    bl_description = "Update Particles Display"

    def execute(self,context):
        dyna_groom = context.scene.dyna_groom_prop

        dyna_groom.int_particle_edit_display_step = bpy.context.scene.tool_settings.particle_edit.display_step
        dyna_groom.bool_particle_edit_show_children = bpy.context.scene.tool_settings.particle_edit.show_particles
        return{'FINISHED'}

class SetWeight0(Operator):
    bl_idname = "hair.set_weight_0"
    bl_label = "Set Weight 0"
    bl_description = "Set Weight 0"

    def execute(self,context):
        bpy.context.scene.tool_settings.particle_edit.brush.strength = 0.001
        bpy.ops.particle.weight_set(factor=1)

        return{'FINISHED'}

class SetWeight50(Operator):
    bl_idname = "hair.set_weight_50"
    bl_label = "Set Weight 50"
    bl_description = "Set Weight 50"

    def execute(self,context):
        bpy.context.scene.tool_settings.particle_edit.brush.strength = 0.5
        bpy.ops.particle.weight_set(factor=1)

        return{'FINISHED'}

class SetWeight100(Operator):
    bl_idname = "hair.set_weight_100"
    bl_label = "Set Weight 100"
    bl_description = "Set Weight 100"

    def execute(self,context):
        bpy.context.scene.tool_settings.particle_edit.brush.strength = 1
        bpy.ops.particle.weight_set(factor=1)

        return{'FINISHED'}

class SetEqualDisplaySegments(Operator):
    bl_idname = "hair.set_equal_display_segments"
    bl_label = "Adjust Display"
    bl_description = "Make hair strand looks better according to the amount of segments"

    def execute(self,context):
        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id

        value_to_set = bpy.context.object.particle_systems[idx_particle].settings.hair_step
        bpy.context.object.particle_systems[idx_particle].settings.display_step = value_to_set
        bpy.context.object.particle_systems[idx_particle].settings.render_step = value_to_set
        bpy.context.object.particle_systems[idx_particle].settings.use_hair_bspline = True

        bpy.context.scene.tool_settings.particle_edit.display_step = value_to_set
        bpy.context.scene.render.hair_type = 'STRIP'
        update_hair_values_on_panel(context)

        return{'FINISHED'}


class UpdtPreserveRootLength(Operator):
    bl_idname = "hair.updt_preserve_root_length"
    bl_label = "Update Preserve Root and Length"
    bl_description = "Update Preserve Root and Length"

    def execute(self,context):
        dyna_groom = context.scene.dyna_groom_prop
        dyna_groom.bool_particle_edit_preserve_root = bpy.context.scene.tool_settings.particle_edit.use_preserve_root 
        dyna_groom.bool_particle_edit_preserve_length = bpy.context.scene.tool_settings.particle_edit.use_preserve_length

        return{'FINISHED'}
# bpy.context.scene.tool_settings.particle_edit.use_preserve_root = True
# bpy.context.scene.tool_settings.particle_edit.use_preserve_length = False
# bpy.context.scene.tool_settings.particle_edit.use_preserve_length = True

class UnselectAll(Operator):
    bl_idname = "hair.unselect"
    bl_label = "Unselect"
    bl_description = "Unselect"

    def execute(self,context):
        bpy.ops.particle.select_all(action='DESELECT')

        return{'FINISHED'}

from . cache_manipulation import *
class CacheManipulationTest(Operator):
    bl_idname = "hair.cache_manipulation_teste"
    bl_label = "TEST!!!Cache Manipulation"
    bl_description = "Cache Manipulation Test, Dont use it you will get an error :)"

    def execute(self,context):
        
        path = r'D:\tmp\blendcache_test_dynamic'

        #In usage, you'll first load the cache you have thus far:
        cache = PointCache(path,0)
        print(cache.last_filename)

        # Then you can load frames from the cache. For instance, if you want to get the very last frame in the cache (I believe that was one of my changes), you can go:
        frame=CacheFrame(cache.last_filename)
        frame.read(path,True)

        #And now you can access all the data you might want. - phonybone used this in the Tube project for cloth simulation. My usage is for particle simulation. Both works just fine. For instance, if you want the location of all your particles, you can go:
        locdata=frame.get_data('LOCATION') # [(x1,y1,z1),(x2,y2,z2),...]
        # print('locadata: ',locdata)


        #You can modify it somehow and then save it again with
        # frame.set_data('LOCATION',new_locdata) #at this point it's only in python
        # frame.write(my_directory) # this updates the cache

        return{'FINISHED'}


########################################
#### UI List options

class LIST_OT_NewItem(Operator):
    """Add a new item to the list."""

    bl_idname = "hair_list.new_item"
    bl_label = "Add a new item"

    def execute(self, context):


        # dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 
        
        
        # if bpy.context.active_object.particle_systems.active_index != int(id_to_update_name)-1:
        #     bpy.context.active_object.particle_systems.active_index = int(id_to_update_name)-1
        

        # if context.mode != 'PARTICLE':
        #     bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        # context.scene.hair_list.add()
        context.active_object.hair_list.add()
        bpy.ops.object.particle_system_add()
        last_hair_list = len(context.active_object.hair_list)
        # last_particle = len(bpy.data.particle)
        # bpy.data.particles[last_particle-1].type = 'HAIR'
        last_particle_sys = len(bpy.context.active_object.particle_systems)
        bpy.context.active_object.particle_systems[last_particle_sys-1].settings.type = 'HAIR'

        # context.scene.hair_list[last_hair_list-1].name = bpy.context.active_object.particle_systems[last_particle_sys-1].name
        # context.scene.hair_list[last_hair_list-1].particle_system_id = last_particle_sys-1
        context.active_object.hair_list[last_hair_list-1].name = bpy.context.active_object.particle_systems[last_particle_sys-1].name
        context.active_object.hair_list[last_hair_list-1].orig_name = bpy.context.active_object.particle_systems[last_particle_sys-1].name
        context.active_object.hair_list[last_hair_list-1].particle_system_id = last_particle_sys-1

        context.active_object.hair_list_index = last_particle_sys-1
        return{'FINISHED'}

class LIST_OT_DeleteItem(Operator):
    """Delete the selected item from the list."""

    bl_idname = "hair_list.delete_item"
    bl_label = "Delete a Particle"

    @classmethod
    def poll(cls, context):
        # return context.scene.hair_list
        return context.active_object.hair_list

    def invoke(self, context, event):
        return context.window_manager.invoke_confirm(self, event)

    def execute(self, context):

        
        BlockHandler.value = 1

        
        # hair_list = context.scene.hair_list
        # index = context.scene.hair_list_index
        hair_list = context.active_object.hair_list
        index = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[index].particle_system_id

        if bpy.context.active_object.particle_systems.active_index != idx_particle:
            bpy.context.active_object.particle_systems.active_index = idx_particle
     
     
        bpy.ops.object.particle_system_remove()


        hair_list.remove(index)


        # context.scene.hair_list_index = min(max(0, index - 1), len(hair_list) - 1)
        context.active_object.hair_list_index = min(max(0, index - 1), len(hair_list) - 1)


        ### apagar a particula

        self.report({'INFO'}, "Particle removed")

        # block_handler.set_block(0)
        BlockHandler.value =0

        return{'FINISHED'}

class LIST_OT_MoveItem(Operator):
    """Move an item in the list."""

    bl_idname = "hair_list.move_item"
    bl_label = "Move an item in the list"

    direction: bpy.props.EnumProperty(items=(('UP', 'Up', ""),
                                              ('DOWN', 'Down', ""),))

    @classmethod
    def poll(cls, context):
        # return context.scene.hair_list
        return context.active_object.hair_list

    def move_index(self):
        """ Move index of an item render queue while clamping it. """

        # index = bpy.context.scene.hair_list_index
        # list_length = len(bpy.context.scene.hair_list) - 1  # (index starts at 0)
        index = bpy.context.active_object.hair_list_index
        list_length = len(bpy.context.active_object.hair_list) - 1  # (index starts at 0)
        new_index = index + (-1 if self.direction == 'UP' else 1)

        # bpy.context.scene.hair_list_index = max(0, min(new_index, list_length))
        bpy.context.active_object.hair_list_index = max(0, min(new_index, list_length))

    def execute(self, context):
        # hair_list = context.scene.hair_list
        # index = context.scene.hair_list_index
        hair_list = context.active_object.hair_list
        index = context.active_object.hair_list_index

        neighbor = index + (-1 if self.direction == 'UP' else 1)
        hair_list.move(neighbor, index)
        self.move_index()

        return{'FINISHED'}


class LSIT_OT_SelectItem(Operator):
    """Move an item in the list."""

    bl_idname = "hair_list.select_item"
    bl_label = "Select item up/down in list"

    direction: bpy.props.EnumProperty(items=(('UP', 'Up', ""),
                                              ('DOWN', 'Down', ""),))

    #### Se eu deixar isso ligado, ele desativa o botao quando chega no primeiro
    # @classmethod
    # def poll(cls, context):
    #     # return context.scene.hair_list
    #     return context.active_object.hair_list_index

    def select_index(self):
        """ Move index of an item render queue while clamping it. """

        # index = bpy.context.scene.hair_list_index
        # list_length = len(bpy.context.scene.hair_list) - 1  # (index starts at 0)
        index = bpy.context.active_object.hair_list_index
        list_length = len(bpy.context.active_object.hair_list) - 1  # (index starts at 0)
        new_index = index + (-1 if self.direction == 'UP' else 1)

        bpy.context.active_object.hair_list_index = max(0, min(new_index, list_length))

    def execute(self, context):
        # hair_list = context.scene.hair_list
        # index = context.scene.hair_list_index
        hair_list = context.active_object.hair_list
        index = context.active_object.hair_list_index

        # neighbor = index + (-1 if self.direction == 'UP' else 1)
        # hair_list.move(neighbor, index)
        self.select_index()

        return{'FINISHED'}


class UpdtParticleCurrent(Operator):
    bl_idname = "hair.updt_particle_current"
    bl_label = "Update Particle Current" #tentativa de conserta problema the Shubham Patil

    def execute(self,context):

        qty_ob_partic = len(context.active_object.hair_list)
        context.active_object.hair_list_index = qty_ob_partic-1

        return{'FINISHED'}


class UpdtParticleList(Operator):
    bl_idname = "hair.updt_particle_list"
    bl_label = "Update Particle List"

    def execute(self,context):
        #esse é um comando para atualiza o desgraph. atualizando, o handler deve funcionar.
        bpy.context.view_layer.update()

        qty_particles = len(bpy.context.active_object.particle_systems)
        qty_ob_partic = len(bpy.context.active_object.hair_list)

        if qty_particles > 0:
            if qty_ob_partic == 0:
                for i,hair_partic in enumerate(bpy.context.active_object.particle_systems):
                    bpy.context.active_object.hair_list.add()
                    bpy.context.active_object.hair_list[i].name = hair_partic.name
                    bpy.context.active_object.hair_list[i].orig_name = hair_partic.name
                    bpy.context.active_object.hair_list[i].particle_system_id = i
            elif qty_particles > qty_ob_partic:
                obj_orig_names = []
                for obj_part in bpy.context.active_object.hair_list:
                    obj_orig_names.append(obj_part.name) #gera lista de nomes para comparar com nomes das particulas
                for part in bpy.context.active_object.particle_systems:
                    if part.name not in obj_orig_names: #checa se falta alguma particula
                        print('nao tem: ',part.name)
                        i = len(bpy.context.active_object.hair_list) #pego o len por que como vou usar como id (que comeca em zero) ele ja estaria com o novo valor de id, eu nao precisaria acrescentar +1
                        bpy.context.active_object.hair_list.add()
                        bpy.context.active_object.hair_list[i].name = part.name
                        bpy.context.active_object.hair_list[i].orig_name = part.name
                        bpy.context.active_object.hair_list[i].particle_system_id = i
                #apos reinserir os dados, e necessario checar se todos os ids estao corretos
                for partic_id,part in enumerate(bpy.context.active_object.particle_systems):
                    for obj_part in bpy.context.active_object.hair_list:
                        if part.name == obj_part.orig_name and obj_part.particle_system_id != partic_id: #se o nome for igaal, mas o id diferente, atualizar id no hair_part
                            print('ajustar id')
                            obj_part.particle_system_id = partic_id
            elif qty_particles < qty_ob_partic: # se tiver mais particulas listadas do que realmente existem
                part_names = []
                for part in bpy.context.active_object.particle_systems:
                    part_names.append(part.name) #gera lista de nomes para comparar com nomes das particulas
                obj_orig_name_to_remove = []
                for obj_part in bpy.context.active_object.hair_list:
                    if obj_part.orig_name not in part_names: #checa se falta alguma particula
                        print('nao tem, tem qeu retirar: ',obj_part.orig_name)
                        obj_orig_name_to_remove.append(obj_part.orig_name)
                
                #apos montar a lista do que retirar, retirar os nomes da listagem no objeto
                
                hair_list = bpy.context.active_object.hair_list
                for i_hair_remove,hair_remove_from_list in enumerate(hair_list):
                    if hair_remove_from_list.orig_name in obj_orig_name_to_remove:
                        hair_list.remove(i_hair_remove)
            else: #nesse caso, sobra apenas se a quantidade for igual antre ambos, vale aqui checar se os IDs entre a lista e as particulas es~toa corretos.
                part_names = []
                for part in bpy.context.active_object.particle_systems:
                    part_names.append(part.name) #gera lista de nomes para comparar com nomes das particulas
                for i,p_name in enumerate(part_names): #o "i" seria o id do particle
                    for idx_hl,hair_list in enumerate(bpy.context.active_object.hair_list):
                        if hair_list.orig_name == p_name and hair_list.particle_system_id != i:
                            bpy.context.active_object.hair_list[idx_hl].particle_system_id = i

        return{'FINISHED'}

        #### UI List options
        ########################################


class Rekey(Operator):
    bl_idname = "hair.rekey"
    bl_label = "Rekey"
    bl_description = "Rekey Particles"

    def execute(self,context):
        dyna_groom = bpy.context.scene.dyna_groom_prop
        int_rekey = dyna_groom.int_rekey_number

        bpy.ops.particle.rekey(keys_number=int_rekey)
        bpy.ops.particle.select_all(action='DESELECT')


        return{'FINISHED'}

class UnifyLength(Operator):
    bl_idname = "hair.unify_length"
    bl_label = "Unify Length"
    bl_description = "Unify Length"

    def execute(self,context):

        bpy.ops.particle.unify_length()
        # layer = bpy.context.view_layer
        # layer.update()
        # bpy.context.view_layer.update()
        bpy.ops.particle.select_all(action='DESELECT')

        return{'FINISHED'}


###########################
#### Shapekeys
class CreateHairShapekey(Operator):
    bl_idname = "hair_list.create_hair_shapekey"
    bl_label = "Create"
    bl_description = "Create Shapekeys"

    def execute(self,context):

        idx = bpy.context.active_object.hair_list_index
        idx_particle = bpy.context.active_object.hair_list[idx].particle_system_id
           
        deps_graph = bpy.context.evaluated_depsgraph_get()
        evaluated_object = bpy.context.object.evaluated_get(deps_graph)
        particle_system = evaluated_object.particle_systems.active
        
        hairs = []

        for p in particle_system.particles:
            hair = []
            for v in p.hair_keys:
                hair.append([v.co[0], v.co[1], v.co[2]])
            hairs.append(hair)
        
        save_hairs = json.dumps(hairs)

        idx_shapekey = len(context.object.particle_systems[idx_particle].settings.particle_shape)

        if idx_shapekey == 0:
            context.object.particle_systems[idx_particle].settings.particle_shape.add()
            context.object.particle_systems[idx_particle].settings.particle_shape[idx_shapekey].partic_data = save_hairs
            context.object.particle_systems[idx_particle].settings.particle_shape[idx_shapekey].partic_name = 'Base'
        else:
            context.object.particle_systems[idx_particle].settings.particle_shape.add()
            context.object.particle_systems[idx_particle].settings.particle_shape[idx_shapekey].partic_data = save_hairs
        
        hair_settings = context.object.particle_systems[idx_particle].settings
        # hair_list_shapekey = hair_settings.particle_shape
        hair_settings.particle_shape_index
        
        new_idx = len(context.object.particle_systems[idx_particle].settings.particle_shape)-1
        hair_settings.particle_shape_index = new_idx

            
        return{'FINISHED'}

class DeleteHairShapekey(Operator):
    """Delete the selected item from the list."""

    bl_idname = "hair_list.delete_hair_shapekey"
    bl_label = "Delete"

    @classmethod
    def poll(cls, context):
        idx = bpy.context.active_object.hair_list_index
        idx_particle = bpy.context.active_object.hair_list[idx].particle_system_id
        return context.object.particle_systems[idx_particle].settings.particle_shape

    def invoke(self, context, event):
        return context.window_manager.invoke_confirm(self, event)

    def execute(self, context):
        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.object.particle_systems[idx_particle].settings
        hair_list_shapekey = hair_settings.particle_shape

        index = hair_settings.particle_shape_index
        # idx_particle = context.active_object.hair_list[index].particle_system_id


        hair_list_shapekey.remove(index)

        # context.scene.hair_list_index = min(max(0, index - 1), len(hair_list) - 1)
        hair_settings.particle_shape_index = min(max(0, index - 1), len(hair_list_shapekey) - 1)
        self.report({'INFO'}, "Shapekey removed")

        return{'FINISHED'}


class StopAndStyle(Operator):
    bl_idname = "hair.stop_and_style"
    bl_label = "Stop and Style"
    bl_description = "Stop simulation and Style Hair"

    def execute(self,context):
        bpy.ops.screen.animation_cancel(restore_frame=False)
        if context.mode != 'PARTICLE':
            bpy.ops.object.mode_set(mode='PARTICLE_EDIT')

        return{'FINISHED'}


class CurrentCacheToBake(Operator):
    bl_idname = "hair.current_cache_to_bake"
    bl_label = "Current to Bake"
    bl_description = "Current Cache to Bake"

    def execute(self,context):
        idx = bpy.context.active_object.hair_list_index
        idx_particle = bpy.context.active_object.hair_list[idx].particle_system_id
        a = {}
        a['point_cache'] = bpy.context.object.particle_systems[idx_particle].point_cache
        bpy.ops.ptcache.bake_from_cache(a)
        
        
        return{'FINISHED'}

class DeleteBakes(Operator):
    bl_idname = "hair.delete_bakes"
    bl_label = "Delete All Bakes"
    bl_description = "Delete All Bakes"

    def execute(self,context):
        bpy.ops.ptcache.free_bake_all()
        # bpy.ops.particle.edited_clear()
        return{'FINISHED'}

class PlayPauseStyle(Operator):
    bl_idname = "hair.play_pause_style"
    bl_label = "Play/Pause Style"
    bl_description = "Play/Pause Style"

    def execute(self,context):

        if not bpy.context.screen.is_animation_playing:
            if context.mode != 'OBJECT':
                bpy.ops.object.mode_set(mode='OBJECT')
            bpy.ops.screen.animation_play()
        else:
            if context.mode != 'PARTICLE':
                bpy.ops.object.mode_set(mode='PARTICLE_EDIT')
            bpy.ops.screen.animation_play()

        return{'FINISHED'}



class ShapekeyApplyTest(Operator):
    bl_idname = "hair.shapekey_apply_test"
    bl_label = "Shapekey Apply Test"
    bl_description = "Shapekey Apply Test"

    def execute(self,context):

        dyna_groom = bpy.context.scene.dyna_groom_prop
        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.active_object.particle_systems[idx_particle].settings
        hair_list_shapekey = hair_settings.particle_shape
        hair_list_shapekey_index = hair_settings.particle_shape_index



        load_base = json.loads(hair_list_shapekey[0].partic_data)
        for i_ps,ps in enumerate(hair_list_shapekey):
            # print (i_ps,' - ',ps.partic_name)
            # if i_ps ==1: #guada a informacao da base shapekey
            #     load_last = load_base
            if i_ps >= 1: #no i_ps =1 o last é  load_base, por isso o post_influence esta vazio
                if i_ps == 1:
                    load_last = load_base
                else:
                    load_last = json.loads(hair_settings.particle_shape[i_ps-1].partic_data_post_influence)
                    # load_last = json.loads(hair_settings.particle_last_shape)
                #carrega dado atual
                load_hair = json.loads(ps.partic_data)
                influence = ps.partic_shapekey_influence

                bpy.ops.object.mode_set(mode='OBJECT')
                deps_graph = bpy.context.evaluated_depsgraph_get()
                evaluated_object = bpy.context.object.evaluated_get(deps_graph)
                particle_system = evaluated_object.particle_systems.active

                precision = 4
                precision_string = "{:."+str(precision)+"f}" #ajuste necessario pois, apesar de nao mover alguns pontos, propositalmente, eles acabam sendo movimentados, e isso bagunca o funcionamento

                # for p,base,l_last,hair in zip(particle_system.particles,load_base,load_last,load_hair): #fios de cabelo
                for i_h,hair_strand in enumerate(zip(particle_system.particles,load_base,load_last,load_hair)): #fios de cabelo
                    p = hair_strand[0]
                    base = hair_strand[1]
                    l_last = hair_strand[2]
                    hair = hair_strand[3]
                    # for v,b,ll,h in zip(p.hair_keys,base,l_last,hair): #ponto dos fios de cabelo "keys"
                    for i_h_key,hair_keys in enumerate(zip(p.hair_keys,base,l_last,hair)): #ponto dos fios de cabelo "keys"
                        v = hair_keys[0]
                        b = hair_keys[1]
                        ll = hair_keys[2]
                        h = hair_keys[3]
                        # print(i_h,'-',i_h_key)
                        # if b[0] != h[0]:
                        # if "{:.4f}".format(b[0]) != "{:.4f}".format(h[0]) :
                        if precision_string.format(b[0]) != precision_string.format(h[0]) :
                            v.co[0] = ll[0]+((h[0] - ll[0]) * influence)
                        else:
                            v.co[0] = ll[0]
                        # if b[1] != h[1]:
                        # if "{:.4f}".format(b[1]) != "{:.4f}".format(h[1]) :
                        if precision_string.format(b[1]) != precision_string.format(h[1]) :
                            v.co[1] = ll[1]+((h[1] - ll[1]) * influence)
                        else:
                            v.co[1] = ll[1]
                        # if b[2] != h[2]:
                        # if "{:.4f}".format(b[2]) != "{:.4f}".format(h[2]) :
                        if precision_string.format(b[2]) != precision_string.format(h[2]) :
                                v.co[2] = ll[2]+((h[2] - ll[2]) * influence)
                        else:
                            v.co[2] = ll[2]

                #ao terminar de rodar todos os fios de cabelo
                bpy.ops.object.mode_set(mode='PARTICLE_EDIT')
                bpy.ops.object.mode_set(mode='OBJECT') #fixar os valores

                    # Apos processar, guardar a nva forma na propriedade particle_last_shape


                deps_graph = bpy.context.evaluated_depsgraph_get()
                evaluated_object = bpy.context.object.evaluated_get(deps_graph)
                particle_system = evaluated_object.particle_systems.active
                
                hairs = []

                for p in particle_system.particles:
                    hair = []
                    for v in p.hair_keys:
                        hair.append([v.co[0], v.co[1], v.co[2]])
                    hairs.append(hair)

                hairs____ = hairs
                
                save_hairs = json.dumps(hairs)
                # hair_settings.particle_last_shape = save_hairs
                ps.partic_data_post_influence = save_hairs

        return{'FINISHED'}

class SelectLinked(Operator):
    bl_idname = "hair.select_linked"
    bl_label = "Linked"
    bl_description = "Select Linked"

    def execute(self,context):

        bpy.ops.particle.select_linked()


        return{'FINISHED'}


class SaveHairShapePreset(Operator):
    bl_idname = "hair.save_hair_shape_preset"
    bl_label = "Save Hair Shape Preset"
    bl_description = "Save Hair Shape Preset"

    def execute(self,context):
        # from .variables import Variables
        dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 

        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.active_object.particle_systems[idx_particle].settings
        hair_list_shapekey = hair_settings.particle_shape
        hair_list_shapekey_index = hair_settings.particle_shape_index

        o_ps = 'bpy.context.object.particle_systems[idx_particle].'
        ao_ps_s = 'bpy.context.active_object.particle_systems[idx_particle].settings.'
        ao_ps_c = 'bpy.context.active_object.particle_systems[idx_particle].cloth.'

        hair_preset =[  #hair shape
                        ['d',ao_ps_s+'shape' , eval(ao_ps_s+'shape')],
                        ['d',ao_ps_s+'root_radius' , eval(ao_ps_s+'root_radius')],
                        ['d',ao_ps_s+'tip_radius' , eval(ao_ps_s+'tip_radius')],
                        ['f',ao_ps_s+'radius_scale' , eval(ao_ps_s+'radius_scale')],
                        ['d',ao_ps_s+'use_close_tip' , eval(ao_ps_s+'use_close_tip')]
        ]

        folder_path = os.path.dirname(os.path.realpath(__file__))
        name_preset = dyna_groom.str_save_hair_shape_preset_name
            
        preset_file = os.path.join(folder_path, 'presets', 'SHAPE_'+name_preset+'.json')
        preset_file = uniquify(preset_file)

        #save!!!
        import json
        with open(preset_file, 'w') as f:
            json.dump(hair_preset, f)

        return{'FINISHED'}



class LoadHairShapePreset(Operator):
    bl_idname = "hair.load_hair_shape_preset"
    bl_label = "Load Hair Shape Preset"
    bl_description = "Load Hair Shape Preset"

    def execute(self,context):
        # from .variables import Variables
        dyna_groom = context.scene.dyna_groom_prop
        
        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id

                                   


        folder_path = os.path.dirname(os.path.realpath(__file__))
        name_preset_load = dyna_groom.enum_hair_shape_presets.replace('.json','')
            
        preset_file = os.path.join(folder_path, 'presets', name_preset_load+'.json')

        # import json
        with open(preset_file) as json_file:
            data = json.load(json_file)

        for d in data:
            #temporariamente fazer bypass quando salvar preset com cores
            if d[1] !=  'bpy.context.active_object.particle_systems[idx_particle].settings.material_slot':
                if d[0] == 'f' or d[0] == 'd':
                    exec('%s = %f' %(d[1], d[2]))
                if d[0] == 's':
                    exec('%s = %a' %(d[1], d[2]))


        update_hair_values_on_panel(context)

        return{'FINISHED'}


##checkpoint hair shape
class SaveCheckpointHairShapePreset(Operator):
    bl_idname = "hair.save_checkpoint_hair_shape_preset"
    bl_label = "Save Checkpoint Hair Shape Preset"
    bl_description = "Save Checkpoint Hair Shape Preset"

    def execute(self,context):
        # from .variables import Variables
        dyna_groom = context.scene.dyna_groom_prop

        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.active_object.particle_systems[idx_particle].settings
        hair_list_shapekey = hair_settings.particle_shape
        hair_list_shapekey_index = hair_settings.particle_shape_index

        o_ps = 'bpy.context.object.particle_systems[idx_particle].'
        ao_ps_s = 'bpy.context.active_object.particle_systems[idx_particle].settings.'
        ao_ps_c = 'bpy.context.active_object.particle_systems[idx_particle].cloth.'

        hair_preset =[  #hair shape
                        ['d',ao_ps_s+'shape' , eval(ao_ps_s+'shape')],
                        ['d',ao_ps_s+'root_radius' , eval(ao_ps_s+'root_radius')],
                        ['d',ao_ps_s+'tip_radius' , eval(ao_ps_s+'tip_radius')],
                        ['f',ao_ps_s+'radius_scale' , eval(ao_ps_s+'radius_scale')],
                        ['d',ao_ps_s+'use_close_tip' , eval(ao_ps_s+'use_close_tip')]
        ]

        bool_local = dyna_groom.bool_check_point_local_hair_shape
        if bool_local:
            item = context.active_object.hair_list[context.active_object.hair_list_index]
            item.checkpoint_hair_shape = json.dumps(hair_preset)
        else:
            dyna_groom.str_global_checkpoint_hair_shape = json.dumps(hair_preset)

        return{'FINISHED'}
        
class LoadCheckpointHairShapePreset(Operator):
    bl_idname = "hair.load_checkpoint_hair_shape_preset"
    bl_label = "Load Checkpoint Hair Shape Preset"
    bl_description = "Load Checkpoint Hair Shape Preset"

    def execute(self,context):
        # from .variables import Variables
        dyna_groom = context.scene.dyna_groom_prop

        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.active_object.particle_systems[idx_particle].settings
        hair_list_shapekey = hair_settings.particle_shape
        hair_list_shapekey_index = hair_settings.particle_shape_index

        # o_ps = 'bpy.context.object.particle_systems[idx_particle].'
        # ao_ps_s = 'bpy.context.active_object.particle_systems[idx_particle].settings.'
        # ao_ps_c = 'bpy.context.active_object.particle_systems[idx_particle].cloth.'

        

        bool_local = dyna_groom.bool_check_point_local_hair_shape
        if bool_local:
            item = context.active_object.hair_list[context.active_object.hair_list_index]
            json_data = item.checkpoint_hair_shape
        else:
            json_data = dyna_groom.str_global_checkpoint_hair_shape

        data = json.loads(json_data)

        for d in data:
            #temporariamente fazer bypass quando salvar preset com cores
            if d[1] !=  'bpy.context.active_object.particle_systems[idx_particle].settings.material_slot':
                if d[0] == 'f' or d[0] == 'd':
                    exec('%s = %f' %(d[1], d[2]))
                if d[0] == 's':
                    exec('%s = %a' %(d[1], d[2]))


        update_hair_values_on_panel(context)


        return{'FINISHED'}




class SaveHairChildrenPreset(Operator):
    bl_idname = "hair.save_hair_children_preset"
    bl_label = "Save Hair Children Preset"
    bl_description = "Save Hair Children Preset"

    def execute(self,context):
        # from .variables import Variables
        dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 

        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.active_object.particle_systems[idx_particle].settings
        hair_list_shapekey = hair_settings.particle_shape
        hair_list_shapekey_index = hair_settings.particle_shape_index

        o_ps = 'bpy.context.object.particle_systems[idx_particle].'
        ao_ps_s = 'bpy.context.active_object.particle_systems[idx_particle].settings.'
        ao_ps_c = 'bpy.context.active_object.particle_systems[idx_particle].cloth.'

        hair_preset =[  #hair children
                        
                        #Children
                            #OPT1
                            ['s',ao_ps_s+'child_type' , eval(ao_ps_s+'child_type' )],

                            #OPT2
                            #----------
                            # ['s',ao_ps_s+'child_type' , eval(ao_ps_s+'child_type')],
                            #----------
                                ['d',ao_ps_s+'child_nbr' , eval(ao_ps_s+'child_nbr')],
                                ['d',ao_ps_s+'rendered_child_count' , eval(ao_ps_s+'rendered_child_count')],
                                ['d',ao_ps_s+'child_length' , eval(ao_ps_s+'child_length')],
                                ['d',ao_ps_s+'child_length_threshold' , eval(ao_ps_s+'child_length_threshold')],

                                ['d',o_ps+'child_seed' , eval(o_ps+'child_seed')],
                                ['d',ao_ps_s+'child_size' , eval(ao_ps_s+'child_size')],
                                ['d',ao_ps_s+'child_size_random' , eval(ao_ps_s+'child_size_random')],
                                ['f',ao_ps_s+'child_radius' , eval(ao_ps_s+'child_radius')],
                                ['d',ao_ps_s+'child_roundness' , eval(ao_ps_s+'child_roundness')],
                                
                                ##Clumping
                                ['d',ao_ps_s+'use_clump_curve' , eval(ao_ps_s+'use_clump_curve')],
                                ['d',ao_ps_s+'clump_factor' , eval(ao_ps_s+'clump_factor')],
                                ['d',ao_ps_s+'clump_shape' , eval(ao_ps_s+'clump_shape')],
                                ['d',ao_ps_s+'twist' , eval(ao_ps_s+'twist')],
                                ['d',ao_ps_s+'use_twist_curve' , eval(ao_ps_s+'use_twist_curve')],
                                ['d',ao_ps_s+'use_clump_noise' , eval(ao_ps_s+'use_clump_noise')],
                                ['d',ao_ps_s+'clump_noise_size' , eval(ao_ps_s+'clump_noise_size')],
                                    
                                #Roughness
                                ['d',ao_ps_s+'use_roughness_curve' , eval(ao_ps_s+'use_roughness_curve')],
                                ['d',ao_ps_s+'roughness_1' , eval(ao_ps_s+'roughness_1')],
                                ['d',ao_ps_s+'roughness_1_size' , eval(ao_ps_s+'roughness_1_size')],
                                ['d',ao_ps_s+'roughness_endpoint' , eval(ao_ps_s+'roughness_endpoint')],
                                ['d',ao_ps_s+'roughness_end_shape' , eval(ao_ps_s+'roughness_end_shape')],
                                ['d',ao_ps_s+'roughness_2' , eval(ao_ps_s+'roughness_2')],
                                ['d',ao_ps_s+'roughness_2_size' , eval(ao_ps_s+'roughness_2_size')],
                                ['d',ao_ps_s+'roughness_2_threshold' , eval(ao_ps_s+'roughness_2_threshold')],
                                
                                #kink
                                    #Opt1
                                    ['s',ao_ps_s+'kink' , eval(ao_ps_s+'kink')],


                                    #opt coes com variaveis iguas
                                    # ['s',ao_ps_s+'kink = 'CURL
                                    # ['s',ao_ps_s+'kink = 'RADIAL'
                                    # ['s',ao_ps_s+'kink = 'WAVE'
                                    # ['s',ao_ps_s+'kink = 'BRAID'
                                    
                                    #------
                                    ['f',ao_ps_s+'kink_amplitude' , eval(ao_ps_s+'kink_amplitude')],
                                    ['d',ao_ps_s+'kink_amplitude_clump' , eval(ao_ps_s+'kink_amplitude_clump')],
                                    ['d',ao_ps_s+'kink_flat' , eval(ao_ps_s+'kink_flat')],
                                    ['d',ao_ps_s+'kink_frequency' , eval(ao_ps_s+'kink_frequency')],
                                    ['d',ao_ps_s+'kink_shape' , eval(ao_ps_s+'kink_shape')],

                                    #opt com variaveis diferentes
                                    #------
                                    ['f',ao_ps_s+'kink_amplitude' , eval(ao_ps_s+'kink_amplitude')],
                                    ['d',ao_ps_s+'kink_amplitude_random' , eval(ao_ps_s+'kink_amplitude_random')],
                                    ['s',ao_ps_s+'kink_axis' , eval(ao_ps_s+'kink_axis')],
                                    ['d',ao_ps_s+'kink_axis_random' , eval(ao_ps_s+'kink_axis_random')],
                                    ['f',ao_ps_s+'kink_frequency' , eval(ao_ps_s+'kink_frequency')],
                                    ['d',ao_ps_s+'kink_extra_steps' , eval(ao_ps_s+'kink_extra_steps')],

        ]

        folder_path = os.path.dirname(os.path.realpath(__file__))
        name_preset = dyna_groom.str_save_hair_children_preset_name


            
        preset_file = os.path.join(folder_path, 'presets', 'CHILD_'+name_preset+'.json')
        preset_file = uniquify(preset_file)

        #save!!!
        import json
        with open(preset_file, 'w') as f:
            json.dump(hair_preset, f)

        return{'FINISHED'}


class LoadHairChildrenPreset(Operator):
    bl_idname = "hair.load_hair_children_preset"
    bl_label = "Load Hair Children Preset"
    bl_description = "Load Hair Children Preset"

    def execute(self,context):
        # from .variables import Variables
        dyna_groom = context.scene.dyna_groom_prop
        
        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.active_object.particle_systems[idx_particle].settings
        # hair_list_shapekey = hair_settings.particle_shape
        # hair_list_shapekey_index = hair_settings.particle_shape_index

                            


        folder_path = os.path.dirname(os.path.realpath(__file__))
        name_preset_load = dyna_groom.enum_hair_children_presets.replace('.json','')
            
        preset_file = os.path.join(folder_path, 'presets', name_preset_load+'.json')

        import json
        with open(preset_file) as json_file:
            data = json.load(json_file)

        for d in data:
            #temporariamente fazer bypass quando salvar preset com cores
            if d[1] !=  'bpy.context.active_object.particle_systems[idx_particle].settings.material_slot':
                if d[0] == 'f' or d[0] == 'd':
                    exec('%s = %f' %(d[1], d[2]))
                if d[0] == 's':
                    exec('%s = %a' %(d[1], d[2]))


        update_hair_values_on_panel(context)

        return{'FINISHED'}


### checkpoint children
class SaveCheckpointHairChildrenPreset(Operator):
    bl_idname = "hair.save_checkpoint_hair_children_preset"
    bl_label = "Save Checkpoint Hair Children Preset"
    bl_description = "Save Checkpoint Hair Children Preset"

    def execute(self,context):
        # from .variables import Variables
        dyna_groom = context.scene.dyna_groom_prop
        # id_to_update_name = dyna_groom.enum_hair_curr_section
        # if id_to_update_name == '':
        #     id_to_update_name = 1 

        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.active_object.particle_systems[idx_particle].settings
        hair_list_shapekey = hair_settings.particle_shape
        hair_list_shapekey_index = hair_settings.particle_shape_index

        o_ps = 'bpy.context.object.particle_systems[idx_particle].'
        ao_ps_s = 'bpy.context.active_object.particle_systems[idx_particle].settings.'
        ao_ps_c = 'bpy.context.active_object.particle_systems[idx_particle].cloth.'

        hair_preset =[  #hair children
                        
                        #Children
                            #OPT1
                            ['s',ao_ps_s+'child_type' , eval(ao_ps_s+'child_type' )],

                            #OPT2
                            #----------
                            # ['s',ao_ps_s+'child_type' , eval(ao_ps_s+'child_type')],
                            #----------
                                ['d',ao_ps_s+'child_nbr' , eval(ao_ps_s+'child_nbr')],
                                ['d',ao_ps_s+'rendered_child_count' , eval(ao_ps_s+'rendered_child_count')],
                                ['d',ao_ps_s+'child_length' , eval(ao_ps_s+'child_length')],
                                ['d',ao_ps_s+'child_length_threshold' , eval(ao_ps_s+'child_length_threshold')],

                                ['d',o_ps+'child_seed' , eval(o_ps+'child_seed')],
                                ['d',ao_ps_s+'child_size' , eval(ao_ps_s+'child_size')],
                                ['d',ao_ps_s+'child_size_random' , eval(ao_ps_s+'child_size_random')],
                                ['f',ao_ps_s+'child_radius' , eval(ao_ps_s+'child_radius')],
                                ['d',ao_ps_s+'child_roundness' , eval(ao_ps_s+'child_roundness')],
                                
                                ##Clumping
                                ['d',ao_ps_s+'use_clump_curve' , eval(ao_ps_s+'use_clump_curve')],
                                ['d',ao_ps_s+'clump_factor' , eval(ao_ps_s+'clump_factor')],
                                ['d',ao_ps_s+'clump_shape' , eval(ao_ps_s+'clump_shape')],
                                ['d',ao_ps_s+'twist' , eval(ao_ps_s+'twist')],
                                ['d',ao_ps_s+'use_twist_curve' , eval(ao_ps_s+'use_twist_curve')],
                                ['d',ao_ps_s+'use_clump_noise' , eval(ao_ps_s+'use_clump_noise')],
                                ['d',ao_ps_s+'clump_noise_size' , eval(ao_ps_s+'clump_noise_size')],
                                    
                                #Roughness
                                ['d',ao_ps_s+'use_roughness_curve' , eval(ao_ps_s+'use_roughness_curve')],
                                ['d',ao_ps_s+'roughness_1' , eval(ao_ps_s+'roughness_1')],
                                ['d',ao_ps_s+'roughness_1_size' , eval(ao_ps_s+'roughness_1_size')],
                                ['d',ao_ps_s+'roughness_endpoint' , eval(ao_ps_s+'roughness_endpoint')],
                                ['d',ao_ps_s+'roughness_end_shape' , eval(ao_ps_s+'roughness_end_shape')],
                                ['d',ao_ps_s+'roughness_2' , eval(ao_ps_s+'roughness_2')],
                                ['d',ao_ps_s+'roughness_2_size' , eval(ao_ps_s+'roughness_2_size')],
                                ['d',ao_ps_s+'roughness_2_threshold' , eval(ao_ps_s+'roughness_2_threshold')],
                                
                                #kink
                                    #Opt1
                                    ['s',ao_ps_s+'kink' , eval(ao_ps_s+'kink')],


                                    #opt coes com variaveis iguas
                                    # ['s',ao_ps_s+'kink = 'CURL
                                    # ['s',ao_ps_s+'kink = 'RADIAL'
                                    # ['s',ao_ps_s+'kink = 'WAVE'
                                    # ['s',ao_ps_s+'kink = 'BRAID'
                                    
                                    #------
                                    ['f',ao_ps_s+'kink_amplitude' , eval(ao_ps_s+'kink_amplitude')],
                                    ['d',ao_ps_s+'kink_amplitude_clump' , eval(ao_ps_s+'kink_amplitude_clump')],
                                    ['d',ao_ps_s+'kink_flat' , eval(ao_ps_s+'kink_flat')],
                                    ['d',ao_ps_s+'kink_frequency' , eval(ao_ps_s+'kink_frequency')],
                                    ['d',ao_ps_s+'kink_shape' , eval(ao_ps_s+'kink_shape')],

                                    #opt com variaveis diferentes
                                    #------
                                    ['f',ao_ps_s+'kink_amplitude' , eval(ao_ps_s+'kink_amplitude')],
                                    ['d',ao_ps_s+'kink_amplitude_random' , eval(ao_ps_s+'kink_amplitude_random')],
                                    ['s',ao_ps_s+'kink_axis' , eval(ao_ps_s+'kink_axis')],
                                    ['d',ao_ps_s+'kink_axis_random' , eval(ao_ps_s+'kink_axis_random')],
                                    ['f',ao_ps_s+'kink_frequency' , eval(ao_ps_s+'kink_frequency')],
                                    ['d',ao_ps_s+'kink_extra_steps' , eval(ao_ps_s+'kink_extra_steps')],

        ]

        bool_local = dyna_groom.bool_check_point_local_hair_children
        if bool_local:
            item = context.active_object.hair_list[context.active_object.hair_list_index]
            item.checkpoint_hair_children = json.dumps(hair_preset)
        else:
            dyna_groom.str_global_checkpoint_hair_children = json.dumps(hair_preset)

        return{'FINISHED'}


class LoadCheckpointHairChildrenPreset(Operator):
    bl_idname = "hair.load_checkpoint_hair_children_preset"
    bl_label = "Load Checkpoint Hair Children Preset"
    bl_description = "Load Checkpoint Hair Children Preset"

    def execute(self,context):
        # from .variables import Variables
        dyna_groom = context.scene.dyna_groom_prop
        
        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.active_object.particle_systems[idx_particle].settings
        # hair_list_shapekey = hair_settings.particle_shape
        # hair_list_shapekey_index = hair_settings.particle_shape_index


        bool_local = dyna_groom.bool_check_point_local_hair_children
        if bool_local:
            item = context.active_object.hair_list[context.active_object.hair_list_index]
            json_data = item.checkpoint_hair_children
        else:
            json_data = dyna_groom.str_global_checkpoint_hair_children

        data = json.loads(json_data)

        for d in data:
            #temporariamente fazer bypass quando salvar preset com cores
            if d[1] !=  'bpy.context.active_object.particle_systems[idx_particle].settings.material_slot':
                if d[0] == 'f' or d[0] == 'd':
                    exec('%s = %f' %(d[1], d[2]))
                if d[0] == 's':
                    exec('%s = %a' %(d[1], d[2]))


        update_hair_values_on_panel(context)

        return{'FINISHED'}


class Subdivide(Operator):
    bl_idname = "hair.subdivide"
    bl_label = "Subdivide"
    bl_description = "Subdivide"

    def execute(self,context):

        bpy.ops.particle.subdivide()

        return{'FINISHED'}